/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.components.AbstractPeriod;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Period
extends AbstractPeriod {
    private static final long serialVersionUID = -7107623461781510475L;
    private final boolean couponFlow;
    private final boolean notionalFlow;
    private final boolean payer;
    private final boolean isExcludeAccruedInterest;

    public Period(double periodStart, double periodEnd, double fixingDate, double paymentDate, AbstractNotional notional, AbstractProductComponent index, double daycountFraction, boolean couponFlow, boolean notionalFlow, boolean payer, boolean isExcludeAccruedInterest) {
        super(periodStart, periodEnd, fixingDate, paymentDate, notional, index, daycountFraction);
        this.couponFlow = couponFlow;
        this.notionalFlow = notionalFlow;
        this.payer = payer;
        this.isExcludeAccruedInterest = isExcludeAccruedInterest;
    }

    public Period(double periodStart, double periodEnd, double fixingDate, double paymentDate, AbstractNotional notional, AbstractProductComponent index, double daycountFraction, boolean couponFlow, boolean notionalFlow, boolean payer) {
        this(periodStart, periodEnd, fixingDate, paymentDate, notional, index, daycountFraction, couponFlow, notionalFlow, payer, false);
    }

    public Period(double periodStart, double periodEnd, double fixingDate, double paymentDate, AbstractNotional notional, AbstractProductComponent index, boolean couponFlow, boolean notionalFlow, boolean payer) {
        this(periodStart, periodEnd, fixingDate, paymentDate, notional, index, periodEnd - periodStart, couponFlow, notionalFlow, payer);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface values;
        if (evaluationTime >= this.getPaymentDate()) {
            return new RandomVariable(0.0);
        }
        RandomVariableInterface notionalAtPeriodStart = this.getNotional().getNotionalAtPeriodStart(this, model);
        RandomVariableInterface numeraireAtEval = model.getNumeraire(evaluationTime);
        RandomVariableInterface numeraire = model.getNumeraire(this.getPaymentDate());
        if (this.couponFlow) {
            values = this.getCoupon(model);
            values = values.mult(notionalAtPeriodStart);
            values = values.div(numeraire);
            if (this.isExcludeAccruedInterest && evaluationTime >= this.getPeriodStart() && evaluationTime < this.getPeriodEnd()) {
                double nonAccruedInterestRatio = (this.getPeriodEnd() - evaluationTime) / (this.getPeriodEnd() - this.getPeriodStart());
                values = values.mult(nonAccruedInterestRatio);
            }
        } else {
            values = new RandomVariable(0.0, 0.0);
        }
        if (this.notionalFlow) {
            RandomVariableInterface nationalAtPeriodEnd = this.getNotional().getNotionalAtPeriodEnd(this, model);
            if (this.getPeriodStart() > evaluationTime) {
                RandomVariableInterface numeraireAtPeriodStart = model.getNumeraire(this.getPeriodStart());
                values = values.subRatio(notionalAtPeriodStart, numeraireAtPeriodStart);
            }
            if (this.getPeriodEnd() > evaluationTime) {
                RandomVariableInterface numeraireAtPeriodEnd = model.getNumeraire(this.getPeriodEnd());
                values = values.addRatio(nationalAtPeriodEnd, numeraireAtPeriodEnd);
            }
        }
        if (this.payer) {
            values = values.mult(-1.0);
        }
        values = values.mult(numeraireAtEval);
        return values;
    }

    @Override
    public RandomVariableInterface getCoupon(LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface values = this.getIndex().getValue(this.getFixingDate(), model);
        double periodDaycountFraction = this.getDaycountFraction();
        values = values.mult(periodDaycountFraction);
        return values;
    }

    @Override
    public String toString() {
        return "Period [couponFlow=" + this.couponFlow + ", notionalFlow=" + this.notionalFlow + ", payer=" + this.payer + ", toString()=" + super.toString() + "]";
    }
}

