/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class ExposureEstimator
extends AbstractProductComponent {
    private static final long serialVersionUID = 2987369289230532162L;
    private final AbstractLIBORMonteCarloProduct underlying;

    public ExposureEstimator(AbstractLIBORMonteCarloProduct underlying) {
        this.underlying = underlying;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        if (this.underlying instanceof AbstractProductComponent) {
            return ((AbstractProductComponent)this.underlying).queryUnderlyings();
        }
        throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface one = model.getRandomVariableForConstant(1.0);
        RandomVariableInterface zero = model.getRandomVariableForConstant(0.0);
        RandomVariableInterface values = this.underlying.getValue(evaluationTime, model);
        if (values.getFiltrationTime() > evaluationTime) {
            RandomVariableInterface filterNaN = values.isNaN().sub(1.0).mult(-1.0);
            RandomVariableInterface valuesFiltered = values.mult(filterNaN);
            double valuesMean = valuesFiltered.getAverage();
            double valuesStdDev = valuesFiltered.getStandardDeviation();
            double valuesFloor = valuesMean * (1.0 - Math.signum(valuesMean) * 1.0E-5) - 3.0 * valuesStdDev;
            double valuesCap = valuesMean * (1.0 + Math.signum(valuesMean) * 1.0E-5) + 3.0 * valuesStdDev;
            RandomVariableInterface filter = values.barrier(values.sub(valuesFloor), one, zero).mult(values.barrier(values.sub(valuesCap).mult(-1.0), one, zero));
            filter = filter.mult(filterNaN);
            values = values.mult(filter);
            RandomVariableInterface[] regressionBasisFunctions = this.getRegressionBasisFunctions(evaluationTime, model);
            RandomVariableInterface[] filteredRegressionBasisFunctions = new RandomVariableInterface[regressionBasisFunctions.length];
            for (int i = 0; i < regressionBasisFunctions.length; ++i) {
                filteredRegressionBasisFunctions[i] = regressionBasisFunctions[i].mult(filter);
            }
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(filteredRegressionBasisFunctions, regressionBasisFunctions);
            values = condExpEstimator.getConditionalExpectation(values);
        }
        return values;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        double periodLength3;
        double periodLength2;
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        RandomVariableInterface basisFunction = model.getRandomVariableForConstant(1.0);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        int liborPeriodIndex = model.getLiborPeriodIndex(evaluationTime);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        int liborPeriodIndexEnd = liborPeriodIndex + 1;
        double periodLength1 = model.getLiborPeriod(liborPeriodIndexEnd) - model.getLiborPeriod(liborPeriodIndex);
        RandomVariableInterface rate = model.getLIBOR(evaluationTime, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = basisFunction.discount(rate, periodLength1);
        basisFunctions.add(basisFunction);
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(evaluationTime);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength2 = model.getLiborPeriod(liborPeriodIndexEnd = (liborPeriodIndex + model.getNumberOfLibors()) / 2) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1) {
            rate = model.getLIBOR(evaluationTime, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength2);
            basisFunction = basisFunction.discount(rate, periodLength2);
        }
        basisFunction = model.getRandomVariableForConstant(1.0);
        liborPeriodIndex = model.getLiborPeriodIndex(evaluationTime);
        if (liborPeriodIndex < 0) {
            liborPeriodIndex = -liborPeriodIndex - 1;
        }
        if ((periodLength3 = model.getLiborPeriod(liborPeriodIndexEnd = model.getNumberOfLibors()) - model.getLiborPeriod(liborPeriodIndex)) != periodLength1 && periodLength3 != periodLength2) {
            rate = model.getLIBOR(evaluationTime, model.getLiborPeriod(liborPeriodIndex), model.getLiborPeriod(liborPeriodIndexEnd));
            basisFunction = basisFunction.discount(rate, periodLength3);
            basisFunctions.add(basisFunction);
            basisFunction = basisFunction.discount(rate, periodLength3);
        }
        return basisFunctions.toArray(new RandomVariableInterface[0]);
    }
}

