/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionSimple
extends AbstractLIBORMonteCarloProduct {
    private final TimeDiscretizationInterface tenor;
    private final double swaprate;
    private final Swaption swaption;
    private final ValueUnit valueUnit;

    public SwaptionSimple(double swaprate, TimeDiscretizationInterface swapTenor) {
        this(swaprate, swapTenor.getAsDoubleArray(), ValueUnit.VALUE);
    }

    public SwaptionSimple(double swaprate, double[] swapTenor, ValueUnit valueUnit) {
        this.tenor = new TimeDiscretization(swapTenor);
        this.swaprate = swaprate;
        this.swaption = new Swaption(swapTenor[0], this.tenor, swaprate);
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        double swapAnnuity;
        RandomVariableInterface value = this.swaption.getValue(evaluationTime, model);
        if (this.valueUnit == ValueUnit.VALUE) {
            return value;
        }
        ForwardCurveInterface forwardCurve = model.getModel().getForwardRateCurve();
        DiscountCurveInterface discountCurve = model.getModel().getAnalyticModel() != null ? model.getModel().getAnalyticModel().getDiscountCurve(forwardCurve.getDiscountCurveName()) : null;
        double parSwaprate = Swap.getForwardSwapRate(new RegularSchedule(this.tenor), new RegularSchedule(this.tenor), forwardCurve, model.getModel().getAnalyticModel());
        double optionMaturity = this.tenor.getTime(0);
        double strikeSwaprate = this.swaprate;
        double d = swapAnnuity = discountCurve != null ? SwapAnnuity.getSwapAnnuity(this.tenor, discountCurve) : SwapAnnuity.getSwapAnnuity(this.tenor, forwardCurve);
        if (this.valueUnit == ValueUnit.VOLATILITY || this.valueUnit == ValueUnit.VOLATILITYLOGNORMAL) {
            double volatility = AnalyticFormulas.blackScholesOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility);
        }
        if (this.valueUnit == ValueUnit.VOLATILITYNORMAL) {
            double volatility = AnalyticFormulas.bachelierOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility);
        }
        if (this.valueUnit == ValueUnit.INTEGRATEDVARIANCE || this.valueUnit == ValueUnit.INTEGRATEDLOGNORMALVARIANCE) {
            double volatility = AnalyticFormulas.blackScholesOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility * volatility * optionMaturity);
        }
        if (this.valueUnit == ValueUnit.INTEGRATEDNORMALVARIANCE) {
            double volatility = AnalyticFormulas.bachelierOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility * volatility * optionMaturity);
        }
        throw new UnsupportedOperationException("Provided valueUnit not implemented.");
    }

    @Override
    public String toString() {
        return "SwaptionSimple [tenor=" + this.tenor + ", swaprate=" + this.swaprate + ", valueUnit=" + (Object)((Object)this.valueUnit) + "]";
    }

    public static enum ValueUnit {
        VALUE,
        INTEGRATEDLOGNORMALVARIANCE,
        INTEGRATEDNORMALVARIANCE,
        INTEGRATEDVARIANCE,
        VOLATILITYLOGNORMAL,
        VOLATILITYNORMAL,
        VOLATILITY;

    }
}

