/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class ForwardRateVolatilitySurfaceCurvature
extends AbstractLIBORMonteCarloProduct {
    private double tolerance = 0.0;

    public ForwardRateVolatilitySurfaceCurvature() {
    }

    public ForwardRateVolatilitySurfaceCurvature(double tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) {
        TermStructureModelInterface modelBase = model.getModel();
        if (modelBase instanceof LIBORMarketModelInterface) {
            return this.getValues(evaluationTime, (LIBORMarketModelInterface)modelBase);
        }
        throw new IllegalArgumentException("This product requires a simulation where the underlying model is of type LIBORMarketModelInterface.");
    }

    public RandomVariableInterface getValues(double evaluationTime, LIBORMarketModelInterface model) {
        if (evaluationTime > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        AbstractLIBORCovarianceModel covarianceModel = model.getCovarianceModel();
        int numberOfComponents = covarianceModel.getLiborPeriodDiscretization().getNumberOfTimeSteps();
        RandomVariableInterface integratedLIBORCurvature = new RandomVariable(0.0);
        for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
            double timeEnd = covarianceModel.getLiborPeriodDiscretization().getTime(componentIndex);
            int timeEndIndex = covarianceModel.getTimeDiscretization().getTimeIndex(timeEnd);
            if (timeEndIndex < 0) {
                timeEndIndex = -timeEndIndex - 2;
            }
            RandomVariableInterface integratedLIBORCurvatureCurrentRate = new RandomVariable(0.0);
            for (int timeIndex = 0; timeIndex < timeEndIndex - 2; ++timeIndex) {
                double timeStep1 = covarianceModel.getTimeDiscretization().getTimeStep(timeIndex);
                double timeStep2 = covarianceModel.getTimeDiscretization().getTimeStep(timeIndex + 1);
                RandomVariableInterface covarianceLeft = covarianceModel.getCovariance(timeIndex + 0, componentIndex, componentIndex, (RandomVariableInterface[])null);
                RandomVariableInterface covarianceCenter = covarianceModel.getCovariance(timeIndex + 1, componentIndex, componentIndex, (RandomVariableInterface[])null);
                RandomVariableInterface covarianceRight = covarianceModel.getCovariance(timeIndex + 2, componentIndex, componentIndex, (RandomVariableInterface[])null);
                RandomVariableInterface curvatureSquared = covarianceRight.sub(covarianceCenter.mult(2.0)).add(covarianceLeft);
                curvatureSquared = curvatureSquared.div(timeStep1 * timeStep2);
                curvatureSquared = curvatureSquared.squared();
                integratedLIBORCurvatureCurrentRate = integratedLIBORCurvatureCurrentRate.add(curvatureSquared.mult(timeStep1));
            }
            if (timeEnd == 0.0) continue;
            integratedLIBORCurvatureCurrentRate = integratedLIBORCurvatureCurrentRate.div(timeEnd);
            integratedLIBORCurvatureCurrentRate = integratedLIBORCurvatureCurrentRate.sqrt();
            integratedLIBORCurvature = integratedLIBORCurvature.add(integratedLIBORCurvatureCurrentRate);
        }
        integratedLIBORCurvature = integratedLIBORCurvature.div(numberOfComponents);
        return integratedLIBORCurvature.sub(this.tolerance).floor(0.0);
    }
}

