/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class FlexiCap
extends AbstractLIBORMonteCarloProduct {
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] strikes;
    private final int maximumNumberOfExercises;

    public FlexiCap(double[] fixingDates, double[] paymentDates, double[] strikes, int maximumNumberOfExercises) {
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.strikes = strikes;
        this.maximumNumberOfExercises = maximumNumberOfExercises;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface values = new RandomVariable(0.0);
        RandomVariableInterface numberOfExcercises = new RandomVariable((double)this.maximumNumberOfExercises - 0.5);
        for (int period = 0; period < this.fixingDates.length; ++period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            if (evaluationTime > paymentDate) continue;
            double strike = this.strikes[period];
            double periodLength = paymentDate - fixingDate;
            RandomVariableInterface libor = model.getLIBOR(fixingDate, fixingDate, paymentDate);
            RandomVariableInterface numeraire = model.getNumeraire(paymentDate);
            RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(model.getTimeIndex(paymentDate));
            RandomVariableInterface payoff = libor.sub(strike).mult(periodLength);
            RandomVariableInterface indicator = new RandomVariable(1.0).barrier(payoff, (RandomVariableInterface)new RandomVariable(1.0), new RandomVariable(0.0));
            indicator = indicator.barrier(numberOfExcercises, indicator, 0.0);
            payoff = payoff.div(numeraire).mult(monteCarloProbabilities);
            values = values.addProduct(indicator, payoff);
            numberOfExcercises = numberOfExcercises.sub(indicator);
        }
        RandomVariableInterface numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }

    public double[] getStrikes() {
        return this.strikes;
    }
}

