/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class CMSOption
extends AbstractLIBORMonteCarloProduct {
    private final double exerciseDate;
    private final double[] fixingDates;
    private double[] paymentDates;
    private double[] periodLengths;
    private double strike;

    public CMSOption(double exerciseDate, double[] fixingDates, double[] paymentDates, double[] periodLengths, double strike) {
        this.exerciseDate = exerciseDate;
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.periodLengths = periodLengths;
        this.strike = strike;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface valueFixLeg = new RandomVariable(this.fixingDates[this.fixingDates.length - 1], 0.0);
        RandomVariableInterface valueFloatLeg = new RandomVariable(this.paymentDates[this.paymentDates.length - 1], -1.0);
        for (int period = this.fixingDates.length - 1; period >= 0; --period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            double periodLength = this.periodLengths != null ? this.periodLengths[period] : paymentDate - fixingDate;
            RandomVariableInterface libor = model.getLIBOR(this.exerciseDate, fixingDate, paymentDate);
            RandomVariable payoff = new RandomVariable(paymentDate, 1.0 * periodLength);
            valueFixLeg = valueFixLeg.add(payoff);
            valueFloatLeg = valueFloatLeg.discount(libor, periodLength);
            valueFixLeg = valueFixLeg.discount(libor, periodLength);
        }
        valueFloatLeg = valueFloatLeg.add(1.0);
        RandomVariableInterface parSwapRate = valueFloatLeg.div(valueFixLeg);
        RandomVariableInterface payoffUnit = new RandomVariable(this.paymentDates[0], this.periodLengths[0]);
        payoffUnit = payoffUnit.discount(model.getLIBOR(this.exerciseDate, this.fixingDates[0], this.paymentDates[0]), this.paymentDates[0] - this.fixingDates[0]);
        RandomVariableInterface value = parSwapRate.sub(this.strike).floor(0.0).mult(payoffUnit);
        if (this.fixingDates[0] != this.exerciseDate) {
            RandomVariableInterface libor = model.getLIBOR(this.exerciseDate, this.exerciseDate, this.fixingDates[0]);
            double periodLength = this.fixingDates[0] - this.exerciseDate;
            value = value.discount(libor, periodLength);
        }
        RandomVariableInterface numeraire = model.getNumeraire(this.exerciseDate);
        RandomVariableInterface monteCarloProbabilities = model.getMonteCarloWeights(model.getTimeIndex(this.exerciseDate));
        value = value.div(numeraire).mult(monteCarloProbabilities);
        RandomVariableInterface numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        return value;
    }

    public double getValue(ForwardCurveInterface forwardCurve, double swaprateVolatility) {
        double[] swapTenor = new double[this.fixingDates.length + 1];
        System.arraycopy(this.fixingDates, 0, swapTenor, 0, this.fixingDates.length);
        swapTenor[swapTenor.length - 1] = this.paymentDates[this.paymentDates.length - 1];
        TimeDiscretization fixTenor = new TimeDiscretization(swapTenor);
        TimeDiscretization floatTenor = new TimeDiscretization(swapTenor);
        double forwardSwapRate = Swap.getForwardSwapRate(fixTenor, floatTenor, forwardCurve);
        double swapAnnuity = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)fixTenor, forwardCurve);
        double payoffUnit = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(swapTenor[0], swapTenor[1]), forwardCurve) / (swapTenor[1] - swapTenor[0]);
        return AnalyticFormulas.huntKennedyCMSOptionValue(forwardSwapRate, swaprateVolatility, swapAnnuity, this.exerciseDate, swapTenor[swapTenor.length - 1] - swapTenor[0], payoffUnit, this.strike) * (swapTenor[1] - swapTenor[0]);
    }
}

