/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureCovarianceModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureFactorLoadingsModelParametricInterface;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureTenorTimeScalingInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;

public abstract class TermStructureCovarianceModelParametric
implements TermStructureCovarianceModelInterface,
TermStructureTenorTimeScalingInterface,
TermStructureFactorLoadingsModelParametricInterface {
    private static final Logger logger = Logger.getLogger("net.finmath");

    @Override
    public abstract double[] getParameter();

    @Override
    public abstract TermStructureCovarianceModelParametric clone();

    @Override
    public abstract TermStructureCovarianceModelParametric getCloneWithModifiedParameters(double[] var1);

    public TermStructureCovarianceModelParametric getCloneCalibrated(final TermStructureModelInterface calibrationModel, final AbstractLIBORMonteCarloProduct[] calibrationProducts, final double[] calibrationTargetValues, final double[] calibrationWeights, Map<String, Object> calibrationParameters) throws CalculationException {
        if (calibrationParameters == null) {
            calibrationParameters = new HashMap<String, Object>();
        }
        Integer numberOfPathsParameter = (Integer)calibrationParameters.get("numberOfPaths");
        Integer seedParameter = (Integer)calibrationParameters.get("seed");
        Integer maxIterationsParameter = (Integer)calibrationParameters.get("maxIterations");
        Double parameterStepParameter = (Double)calibrationParameters.get("parameterStep");
        Double accuracyParameter = (Double)calibrationParameters.get("accuracy");
        BrownianMotionInterface brownianMotionParameter = (BrownianMotionInterface)calibrationParameters.get("brownianMotion");
        double[] initialParameters = this.getParameter();
        double[] lowerBound = new double[initialParameters.length];
        double[] upperBound = new double[initialParameters.length];
        double[] parameterStep = new double[initialParameters.length];
        double[] zero = new double[calibrationTargetValues.length];
        Arrays.fill(lowerBound, 0.0);
        Arrays.fill(upperBound, Double.POSITIVE_INFINITY);
        Arrays.fill(parameterStep, parameterStepParameter != null ? parameterStepParameter : 1.0E-4);
        Arrays.fill(zero, 0.0);
        int numberOfThreads = 2;
        OptimizerFactoryInterface optimizerFactoryParameter = (OptimizerFactoryInterface)calibrationParameters.get("optimizerFactory");
        int numberOfPaths = numberOfPathsParameter != null ? numberOfPathsParameter : 2000;
        int seed = seedParameter != null ? seedParameter : 31415;
        int maxIterations = maxIterationsParameter != null ? maxIterationsParameter : 400;
        double accuracy = accuracyParameter != null ? accuracyParameter : 1.0E-7;
        final BrownianMotionInterface brownianMotion = brownianMotionParameter != null ? brownianMotionParameter : new BrownianMotion(calibrationModel.getProcess().getStochasticDriver().getTimeDiscretization(), this.getNumberOfFactors(), numberOfPaths, seed);
        OptimizerFactoryInterface optimizerFactory = optimizerFactoryParameter != null ? optimizerFactoryParameter : new OptimizerFactoryLevenbergMarquardt(maxIterations, accuracy, numberOfThreads);
        int numberOfThreadsForProductValuation = 2 * Math.max(2, Runtime.getRuntime().availableProcessors());
        final ExecutorService executor = null;
        OptimizerInterface.ObjectiveFunction calibrationError = new OptimizerInterface.ObjectiveFunction(){

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                int calibrationProductIndex;
                AbstractModelInterface model;
                TermStructureCovarianceModelParametric calibrationCovarianceModel = TermStructureCovarianceModelParametric.this.getCloneWithModifiedParameters(parameters);
                HashMap<String, TermStructureCovarianceModelParametric> data = new HashMap<String, TermStructureCovarianceModelParametric>();
                data.put("covarianceModel", calibrationCovarianceModel);
                try {
                    model = calibrationModel.getCloneWithModifiedData(data);
                }
                catch (CalculationException e) {
                    throw new SolverException(e);
                }
                ProcessEulerScheme process = new ProcessEulerScheme(brownianMotion);
                final TermStructureModelMonteCarloSimulation termStructureModelMonteCarloSimulation = new TermStructureModelMonteCarloSimulation((TermStructureModelInterface)model, process);
                ArrayList<Future<Double>> valueFutures = new ArrayList<Future<Double>>(calibrationProducts.length);
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    final int workerCalibrationProductIndex = calibrationProductIndex;
                    Callable<Double> worker = new Callable<Double>(){

                        @Override
                        public Double call() throws SolverException {
                            try {
                                return calibrationWeights[workerCalibrationProductIndex] * (calibrationProducts[workerCalibrationProductIndex].getValue(termStructureModelMonteCarloSimulation) - calibrationTargetValues[workerCalibrationProductIndex]);
                            }
                            catch (CalculationException e) {
                                return new Double(0.0);
                            }
                            catch (Exception e) {
                                return new Double(0.0);
                            }
                        }
                    };
                    if (executor != null) {
                        Future<Double> valueFuture = executor.submit(worker);
                        valueFutures.add(calibrationProductIndex, valueFuture);
                        continue;
                    }
                    FutureTask<Double> valueFutureTask = new FutureTask<Double>(worker);
                    valueFutureTask.run();
                    valueFutures.add(calibrationProductIndex, valueFutureTask);
                }
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    try {
                        double value;
                        values[calibrationProductIndex] = value = ((Double)((Future)valueFutures.get(calibrationProductIndex)).get()).doubleValue();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new SolverException(e);
                    }
                    catch (ExecutionException e) {
                        throw new SolverException(e);
                    }
                }
                double error = 0.0;
                for (int valueIndex = 0; valueIndex < values.length; ++valueIndex) {
                    double deviation = values[valueIndex];
                    error += deviation * deviation;
                }
                System.out.println(Math.sqrt(error / (double)values.length));
            }
        };
        OptimizerInterface optimizer = optimizerFactory.getOptimizer(calibrationError, initialParameters, lowerBound, upperBound, parameterStep, zero);
        try {
            optimizer.run();
        }
        catch (SolverException e) {
            throw new CalculationException(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        double[] bestParameters = optimizer.getBestFitParameters();
        TermStructureCovarianceModelParametric calibrationCovarianceModel = this.getCloneWithModifiedParameters(bestParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("The solver required " + optimizer.getIterations() + " iterations. The best fit parameters are:");
            String logString = "Best parameters:";
            for (int i = 0; i < bestParameters.length; ++i) {
                logString = logString + "\tparameter[" + i + "]: " + bestParameters[i];
            }
            logger.fine(logString);
        }
        return calibrationCovarianceModel;
    }
}

