/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.interestrate.LIBORMarketModelWithTenorRefinement;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureFactorLoadingsModelInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class TermStructCovarianceModelFromLIBORCovarianceModel
implements TermStructureFactorLoadingsModelInterface {
    private final AbstractLIBORCovarianceModelParametric covarianceModel;

    public TermStructCovarianceModelFromLIBORCovarianceModel(AbstractLIBORCovarianceModelParametric covarianceModel) {
        this.covarianceModel = covarianceModel;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(double time, double periodStart, double periodEnd, TimeDiscretizationInterface periodDiscretization, RandomVariableInterface[] realizationAtTimeIndex, TermStructureModelInterface model) {
        TimeDiscretizationInterface liborPeriodDiscretization = this.covarianceModel.getLiborPeriodDiscretization();
        RandomVariableInterface[] liborAtTimeIndex = new RandomVariableInterface[liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            liborAtTimeIndex[componentIndex] = liborPeriodDiscretization.getTime(componentIndex) < time ? null : ((LIBORMarketModelWithTenorRefinement)model).getLIBORForStateVariable(periodDiscretization, realizationAtTimeIndex, liborPeriodDiscretization.getTime(componentIndex), liborPeriodDiscretization.getTime(componentIndex + 1));
        }
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariableInterface[] factorLoadings = this.covarianceModel.getFactorLoading(time, periodStartIndex, liborAtTimeIndex);
        if (periodEndIndex > periodStartIndex + 1) {
            int factorIndex;
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].mult(liborPeriodDiscretization.getTimeStep(periodStartIndex));
            }
            for (int periodIndex = periodStartIndex + 1; periodIndex < periodEndIndex; ++periodIndex) {
                RandomVariableInterface[] factorLoadingsForPeriod = this.covarianceModel.getFactorLoading(time, periodStartIndex, liborAtTimeIndex);
                double periodLength = liborPeriodDiscretization.getTimeStep(periodIndex);
                for (int factorIndex2 = 0; factorIndex2 < factorLoadings.length; ++factorIndex2) {
                    factorLoadings[factorIndex2] = factorLoadings[factorIndex2].addProduct(factorLoadingsForPeriod[factorIndex2], periodLength);
                }
            }
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].div(periodEnd - periodStart);
            }
        }
        return factorLoadings;
    }

    @Override
    public int getNumberOfFactors() {
        return this.covarianceModel.getNumberOfFactors();
    }
}

