/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.ArrayList;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelFromGivenMatrix
extends LIBORVolatilityModel {
    private final AbstractRandomVariableFactory randomVariableFactory;
    private final double[][] volatilityMatrix;
    private transient double[] parameter = null;
    private transient RandomVariableInterface[][] volatility;

    public LIBORVolatilityModelFromGivenMatrix(AbstractRandomVariableFactory randomVariableFactory, TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double[][] volatility) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.randomVariableFactory = randomVariableFactory;
        this.volatilityMatrix = volatility;
        this.volatility = new RandomVariableInterface[timeDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()];
    }

    public LIBORVolatilityModelFromGivenMatrix(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double[][] volatility) {
        this(new RandomVariableFactory(), timeDiscretization, liborPeriodDiscretization, volatility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getVolatility(int timeIndex, int component) {
        RandomVariableInterface[][] randomVariableInterfaceArray = this.volatility;
        synchronized (this.volatility) {
            if (this.volatility[timeIndex][component] == null) {
                this.volatility[timeIndex][component] = this.randomVariableFactory.createRandomVariable(this.getTimeDiscretization().getTime(timeIndex), this.volatilityMatrix[timeIndex][component]);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.volatility[timeIndex][component];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getParameter() {
        LIBORVolatilityModelFromGivenMatrix lIBORVolatilityModelFromGivenMatrix = this;
        synchronized (lIBORVolatilityModelFromGivenMatrix) {
            if (this.parameter == null) {
                ArrayList<Double> parameterArray = new ArrayList<Double>();
                for (int timeIndex = 0; timeIndex < this.getTimeDiscretization().getNumberOfTimeSteps(); ++timeIndex) {
                    for (int liborPeriodIndex = 0; liborPeriodIndex < this.getLiborPeriodDiscretization().getNumberOfTimeSteps(); ++liborPeriodIndex) {
                        if (!(this.getTimeDiscretization().getTime(timeIndex) < this.getLiborPeriodDiscretization().getTime(liborPeriodIndex))) continue;
                        parameterArray.add(this.volatilityMatrix[timeIndex][liborPeriodIndex]);
                    }
                }
                this.parameter = new double[parameterArray.size()];
                for (int i = 0; i < this.parameter.length; ++i) {
                    this.parameter[i] = (Double)parameterArray.get(i);
                }
            }
        }
        return this.parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        this.parameter = null;
        int parameterIndex = 0;
        for (int timeIndex = 0; timeIndex < this.getTimeDiscretization().getNumberOfTimeSteps(); ++timeIndex) {
            for (int liborPeriodIndex = 0; liborPeriodIndex < this.getLiborPeriodDiscretization().getNumberOfTimeSteps(); ++liborPeriodIndex) {
                if (!(this.getTimeDiscretization().getTime(timeIndex) < this.getLiborPeriodDiscretization().getTime(liborPeriodIndex))) continue;
                this.volatilityMatrix[timeIndex][liborPeriodIndex] = Math.max(parameter[parameterIndex++], 0.0);
            }
        }
        this.volatility = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps()][this.getLiborPeriodDiscretization().getNumberOfTimeSteps()];
    }

    @Override
    public Object clone() {
        double[][] newVolatilityArray = (double[][])this.volatilityMatrix.clone();
        int rows = newVolatilityArray.length;
        for (int row = 0; row < rows; ++row) {
            newVolatilityArray[row] = (double[])newVolatilityArray[row].clone();
        }
        return new LIBORVolatilityModelFromGivenMatrix(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), newVolatilityArray);
    }
}

