/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.Arrays;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModel;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCovarianceModelFromVolatilityAndCorrelation
extends AbstractLIBORCovarianceModelParametric {
    private LIBORVolatilityModel volatilityModel;
    private LIBORCorrelationModel correlationModel;

    public LIBORCovarianceModelFromVolatilityAndCorrelation(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, LIBORVolatilityModel volatilityModel, LIBORCorrelationModel correlationModel) {
        super(timeDiscretization, liborPeriodDiscretization, correlationModel.getNumberOfFactors());
        this.volatilityModel = volatilityModel;
        this.correlationModel = correlationModel;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factorLoading = new RandomVariableInterface[this.correlationModel.getNumberOfFactors()];
        RandomVariableInterface volatility = this.volatilityModel.getVolatility(timeIndex, component);
        for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
            factorLoading[factorIndex] = volatility.mult(this.correlationModel.getFactorLoading(timeIndex, factorIndex, component));
        }
        return factorLoading;
    }

    @Override
    public RandomVariableInterface getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface factorLoadingPseudoInverse = this.volatilityModel.getVolatility(timeIndex, component).invert().mult(this.correlationModel.getFactorLoading(timeIndex, factor, component));
        int numberOfComponents = this.getLiborPeriodDiscretization().getNumberOfTimeSteps();
        double factorWeight = 0.0;
        for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
            double factorElement = this.correlationModel.getFactorLoading(timeIndex, factor, componentIndex);
            factorWeight += factorElement * factorElement;
        }
        factorLoadingPseudoInverse = factorLoadingPseudoInverse.mult(1.0 / factorWeight);
        return factorLoadingPseudoInverse;
    }

    @Override
    public RandomVariableInterface getCovariance(int timeIndex, int component1, int component2, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface covariance = new RandomVariable(0.0, this.correlationModel.getCorrelation(timeIndex, component1, component2));
        covariance = covariance.mult(this.volatilityModel.getVolatility(timeIndex, component1)).mult(this.volatilityModel.getVolatility(timeIndex, component2));
        return covariance;
    }

    @Override
    public double[] getParameter() {
        double[] volatilityParameter = this.volatilityModel.getParameter();
        double[] correlationParameter = this.correlationModel.getParameter();
        int parameterLength = 0;
        parameterLength += volatilityParameter != null ? volatilityParameter.length : 0;
        double[] parameter = new double[parameterLength += correlationParameter != null ? correlationParameter.length : 0];
        int parameterIndex = 0;
        if (volatilityParameter != null) {
            System.arraycopy(volatilityParameter, 0, parameter, parameterIndex, volatilityParameter.length);
            parameterIndex += volatilityParameter.length;
        }
        if (correlationParameter != null) {
            System.arraycopy(correlationParameter, 0, parameter, parameterIndex, correlationParameter.length);
            parameterIndex += correlationParameter.length;
        }
        return parameter;
    }

    @Override
    public Object clone() {
        return new LIBORCovarianceModelFromVolatilityAndCorrelation(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), (LIBORVolatilityModel)this.volatilityModel.clone(), (LIBORCorrelationModel)this.correlationModel.clone());
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        LIBORVolatilityModel volatilityModel = this.volatilityModel;
        LIBORCorrelationModel correlationModel = this.correlationModel;
        double[] volatilityParameter = volatilityModel.getParameter();
        double[] correlationParameter = correlationModel.getParameter();
        int parameterIndex = 0;
        if (volatilityParameter != null) {
            double[] newVolatilityParameter = new double[volatilityParameter.length];
            System.arraycopy(parameters, parameterIndex, newVolatilityParameter, 0, newVolatilityParameter.length);
            parameterIndex += newVolatilityParameter.length;
            if (!Arrays.equals(newVolatilityParameter, volatilityModel.getParameter())) {
                volatilityModel = (LIBORVolatilityModel)volatilityModel.clone();
                volatilityModel.setParameter(newVolatilityParameter);
            }
        }
        if (correlationParameter != null) {
            double[] newCorrelationParameter = new double[correlationParameter.length];
            System.arraycopy(parameters, parameterIndex, newCorrelationParameter, 0, newCorrelationParameter.length);
            parameterIndex += newCorrelationParameter.length;
            if (!Arrays.equals(newCorrelationParameter, correlationModel.getParameter())) {
                correlationModel = (LIBORCorrelationModel)correlationModel.clone();
            }
            correlationModel.setParameter(newCorrelationParameter);
        }
        return new LIBORCovarianceModelFromVolatilityAndCorrelation(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), volatilityModel, correlationModel);
    }

    public LIBORVolatilityModel getVolatilityModel() {
        return this.volatilityModel;
    }

    public LIBORCorrelationModel getCorrelationModel() {
        return this.correlationModel;
    }
}

