/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModel;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCorrelationModelThreeParameterExponentialDecay
extends LIBORCorrelationModel {
    private int numberOfFactors;
    private double a;
    private double b;
    private double c;
    private final boolean isCalibrateable;
    private transient double[][] correlationMatrix;
    private transient double[][] factorMatrix;

    public LIBORCorrelationModelThreeParameterExponentialDecay(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors, double a, double b, double c, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.numberOfFactors = numberOfFactors;
        this.a = a;
        this.b = b;
        this.c = c;
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] parameter = new double[]{this.a, this.b, this.c};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = parameter[0];
        this.b = parameter[1];
        this.c = parameter[2];
        this.factorMatrix = null;
        this.correlationMatrix = null;
    }

    @Override
    public double getFactorLoading(int timeIndex, int factor, int component) {
        if (this.factorMatrix == null) {
            this.initialize(this.numberOfFactors, this.a, this.b, this.c);
        }
        return this.factorMatrix[component][factor];
    }

    @Override
    public double getCorrelation(int timeIndex, int component1, int component2) {
        if (this.correlationMatrix == null) {
            this.initialize(this.numberOfFactors, this.a, this.b, this.c);
        }
        return this.correlationMatrix[component1][component2];
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    private synchronized void initialize(int numberOfFactors, double a, double b, double c) {
        a = Math.max(a, 0.0);
        b = Math.min(Math.max(b, 0.0), 1.0);
        c = Math.max(c, 0.0);
        this.correlationMatrix = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()][this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int row = 0; row < this.correlationMatrix.length; ++row) {
            for (int col = row + 1; col < this.correlationMatrix[row].length; ++col) {
                double correlation;
                double T1 = this.liborPeriodDiscretization.getTime(row);
                double T2 = this.liborPeriodDiscretization.getTime(col);
                this.correlationMatrix[row][col] = correlation = b + (1.0 - b) * Math.exp(-a * Math.abs(T1 - T2) - c * Math.max(T1, T2));
                this.correlationMatrix[col][row] = correlation;
            }
            this.correlationMatrix[row][row] = 1.0;
        }
        this.factorMatrix = LinearAlgebra.factorReduction(this.correlationMatrix, numberOfFactors);
        for (int component1 = 0; component1 < this.factorMatrix.length; ++component1) {
            for (int component2 = component1 + 1; component2 < this.factorMatrix.length; ++component2) {
                double correlation = 0.0;
                for (int factor = 0; factor < this.factorMatrix[component1].length; ++factor) {
                    correlation += this.factorMatrix[component1][factor] * this.factorMatrix[component2][factor];
                }
                this.correlationMatrix[component1][component2] = correlation;
                this.correlationMatrix[component2][component1] = correlation;
            }
            this.correlationMatrix[component1][component1] = 1.0;
        }
    }

    @Override
    public Object clone() {
        this.initialize(this.numberOfFactors, this.a, this.b, this.c);
        LIBORCorrelationModelThreeParameterExponentialDecay newModel = new LIBORCorrelationModelThreeParameterExponentialDecay(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.numberOfFactors, this.a, this.b, this.c, this.isCalibrateable);
        newModel.correlationMatrix = this.correlationMatrix;
        newModel.factorMatrix = this.factorMatrix;
        return newModel;
    }
}

