/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariableInterface;

public class BlendedLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private double displacement;
    private ForwardCurveInterface forwardCurve;
    private boolean isCalibrateable = false;

    public BlendedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, ForwardCurveInterface forwardCurve, double displacement, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.forwardCurve = forwardCurve;
        this.displacement = displacement;
        this.isCalibrateable = isCalibrateable;
    }

    public BlendedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, double displacement, boolean isCalibrateable) {
        this(covarianceModel, null, displacement, isCalibrateable);
    }

    @Override
    public Object clone() {
        return new BlendedLocalVolatilityModel((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.forwardCurve, this.displacement, this.isCalibrateable);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        double[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new double[]{this.displacement};
        }
        double[] jointParameters = new double[covarianceParameters.length + 1];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length] = this.displacement;
        return jointParameters;
    }

    private void setParameter(double[] parameter) {
        if (parameter == null || parameter.length == 0) {
            return;
        }
        if (!this.isCalibrateable) {
            this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(parameter);
            return;
        }
        double[] covarianceParameters = new double[parameter.length - 1];
        System.arraycopy(parameter, 0, covarianceParameters, 0, covarianceParameters.length);
        this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        this.displacement = parameter[covarianceParameters.length];
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        BlendedLocalVolatilityModel model = (BlendedLocalVolatilityModel)this.clone();
        model.setParameter(parameters);
        return model;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
        double forward = 1.0;
        if (this.forwardCurve != null) {
            double timeToMaturity = this.getLiborPeriodDiscretization().getTime(component) - this.getTimeDiscretization().getTime(timeIndex);
            forward = this.forwardCurve.getForward(null, Math.max(timeToMaturity, 0.0));
        }
        if (realizationAtTimeIndex != null && realizationAtTimeIndex[component] != null) {
            RandomVariableInterface localVolatilityFactor = realizationAtTimeIndex[component].mult(1.0 - this.displacement).add(this.displacement * forward);
            for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                factorLoading[factorIndex] = factorLoading[factorIndex].mult(localVolatilityFactor);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariableInterface getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariableInterface[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }
}

