/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureCovarianceModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORMarketModelWithTenorRefinement
extends AbstractModel
implements TermStructureModelInterface {
    private final TimeDiscretizationInterface[] liborPeriodDiscretizations;
    private final Integer[] numberOfDiscretizationIntervalls;
    private String forwardCurveName;
    private AnalyticModelInterface curveModel;
    private ForwardCurveInterface forwardRateCurve;
    private DiscountCurveInterface discountCurve;
    private TermStructureCovarianceModelInterface covarianceModel;
    private final ConcurrentHashMap<Integer, RandomVariableInterface> numeraires;
    private AbstractProcessInterface numerairesProcess = null;

    public LIBORMarketModelWithTenorRefinement(TimeDiscretizationInterface[] liborPeriodDiscretizations, Integer[] numberOfDiscretizationIntervalls, AnalyticModelInterface analyticModel, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, TermStructureCovarianceModelInterface covarianceModel, CalibrationItem[] calibrationItems, Map<String, ?> properties) throws CalculationException {
        Map calibrationParameters = null;
        if (properties != null && properties.containsKey("calibrationParameters")) {
            calibrationParameters = (Map)properties.get("calibrationParameters");
        }
        this.liborPeriodDiscretizations = liborPeriodDiscretizations;
        this.numberOfDiscretizationIntervalls = numberOfDiscretizationIntervalls;
        this.curveModel = analyticModel;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.covarianceModel = covarianceModel;
        if (calibrationItems != null && calibrationItems.length > 0) {
            TermStructureCovarianceModelParametric covarianceModelParametric = null;
            try {
                covarianceModelParametric = (TermStructureCovarianceModelParametric)covarianceModel;
            }
            catch (Exception e) {
                throw new ClassCastException("Calibration is currently restricted to parametric covariance models (TermStructureCovarianceModelParametricInterface).");
            }
            AbstractLIBORMonteCarloProduct[] calibrationProducts = new AbstractLIBORMonteCarloProduct[calibrationItems.length];
            double[] calibrationTargetValues = new double[calibrationItems.length];
            double[] calibrationWeights = new double[calibrationItems.length];
            for (int i = 0; i < calibrationTargetValues.length; ++i) {
                calibrationProducts[i] = calibrationItems[i].calibrationProduct;
                calibrationTargetValues[i] = calibrationItems[i].calibrationTargetValue;
                calibrationWeights[i] = calibrationItems[i].calibrationWeight;
            }
            this.covarianceModel = covarianceModelParametric.getCloneCalibrated(this, calibrationProducts, calibrationTargetValues, calibrationWeights, calibrationParameters);
        }
        this.numeraires = new ConcurrentHashMap();
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        RandomVariableInterface numeraire;
        int timeIndex = this.liborPeriodDiscretizations[0].getTimeIndex(time);
        TimeDiscretizationInterface liborPeriodDiscretization = this.liborPeriodDiscretizations[0];
        if (timeIndex < 0) {
            int upperIndex = -timeIndex - 1;
            int lowerIndex = upperIndex - 1;
            if (lowerIndex < 0) {
                throw new IllegalArgumentException("Numeraire requested for time " + time + ". Unsupported");
            }
            double alpha = (time - liborPeriodDiscretization.getTime(lowerIndex)) / (liborPeriodDiscretization.getTime(upperIndex) - liborPeriodDiscretization.getTime(lowerIndex));
            RandomVariableInterface numeraire2 = this.getNumeraire(liborPeriodDiscretization.getTime(upperIndex)).log().mult(alpha).add(this.getNumeraire(liborPeriodDiscretization.getTime(lowerIndex)).log().mult(1.0 - alpha)).exp();
            if (this.discountCurve != null) {
                double deterministicNumeraireAdjustment = numeraire2.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, time);
                numeraire2 = numeraire2.mult(deterministicNumeraireAdjustment);
            }
            return numeraire2;
        }
        if (this.getProcess() != this.numerairesProcess) {
            this.numeraires.clear();
            this.numerairesProcess = this.getProcess();
        }
        if ((numeraire = this.numeraires.get(timeIndex)) == null) {
            if (timeIndex == 0) {
                numeraire = this.getProcess().getStochasticDriver().getRandomVariableForConstant(1.0);
            } else {
                numeraire = this.getNumeraire(this.liborPeriodDiscretizations[0].getTime(timeIndex - 1));
                double periodStart = this.liborPeriodDiscretizations[0].getTime(timeIndex - 1);
                double periodEnd = this.liborPeriodDiscretizations[0].getTime(timeIndex);
                RandomVariableInterface libor = this.getLIBOR(periodStart, periodStart, periodEnd);
                numeraire = numeraire.accrue(libor, periodEnd - periodStart);
            }
            this.numeraires.put(timeIndex, numeraire);
        }
        if (this.discountCurve != null) {
            double deterministicNumeraireAdjustment = numeraire.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        RandomVariableInterface[] initialStateRandomVariable = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            initialStateRandomVariable[componentIndex] = this.getProcess().getStochasticDriver().getRandomVariableForConstant(0.0);
        }
        return initialStateRandomVariable;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        RandomVariableInterface stateVariable;
        RandomVariableInterface stateVariablePrevious;
        double periodLengthPrevious;
        double periodStartPrevious;
        double periodEnd;
        double periodLength;
        double periodStart;
        int componentIndex;
        double time = this.getTime(timeIndex);
        double timeStep = this.getTimeDiscretization().getTimeStep(timeIndex);
        double timeNext = this.getTime(timeIndex + 1);
        RandomVariableInterface zero = this.getProcess().getStochasticDriver().getRandomVariableForConstant(0.0);
        RandomVariableInterface[] drift = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex2 = 0; componentIndex2 < this.getNumberOfComponents(); ++componentIndex2) {
            drift[componentIndex2] = null;
        }
        RandomVariableInterface[] variances = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex3 = 0; componentIndex3 < this.getNumberOfComponents(); ++componentIndex3) {
            variances[componentIndex3] = zero;
        }
        RandomVariableInterface[] covarianceFactorSums = new RandomVariableInterface[this.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
            covarianceFactorSums[factorIndex] = zero;
        }
        TimeDiscretizationInterface liborPeriodDiscretization = this.getLiborPeriodDiscretization(timeNext);
        for (int componentIndex4 = 0; componentIndex4 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex4) {
            drift[componentIndex4] = zero;
            double periodStart2 = liborPeriodDiscretization.getTime(componentIndex4);
            double periodLength2 = liborPeriodDiscretization.getTimeStep(componentIndex4);
            double periodEnd2 = periodStart2 + periodLength2;
            double tenorTime = this.covarianceModel.getScaledTenorTime(periodStart2, periodEnd2);
            RandomVariableInterface[] factorLoading = this.getFactorLoading(timeIndex, componentIndex4, realizationAtTimeIndex);
            double weight = this.getWeightForTenorRefinement(periodStart2, periodStart2, periodStart2, periodEnd2);
            for (int factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                drift[componentIndex4] = drift[componentIndex4].addProduct(covarianceFactorSums[factorIndex].addProduct(factorLoading[factorIndex], weight), factorLoading[factorIndex]);
                variances[componentIndex4] = variances[componentIndex4].addProduct(factorLoading[factorIndex], factorLoading[factorIndex]);
                covarianceFactorSums[factorIndex] = covarianceFactorSums[factorIndex].addProduct(factorLoading[factorIndex], tenorTime);
            }
        }
        TimeDiscretizationInterface liborPeriodDiscretizationPrevious = this.getLiborPeriodDiscretization(time);
        for (componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            periodStart = liborPeriodDiscretization.getTime(componentIndex);
            periodLength = liborPeriodDiscretization.getTimeStep(componentIndex);
            periodEnd = periodStart + periodLength;
            periodStartPrevious = liborPeriodDiscretizationPrevious.getTime(componentIndex);
            periodLengthPrevious = liborPeriodDiscretizationPrevious.getTimeStep(componentIndex);
            double periodEndPrevious = periodStartPrevious + periodLengthPrevious;
            if (periodStartPrevious == periodStart && periodEndPrevious == periodEnd) continue;
            stateVariablePrevious = this.getStateVariable(timeIndex, periodStartPrevious, periodEndPrevious);
            stateVariable = this.getStateVariable(timeIndex, periodStart, periodEnd);
            if (Double.isNaN(stateVariable.getAverage()) || Double.isNaN(stateVariablePrevious.getAverage())) {
                throw new IllegalArgumentException();
            }
            drift[componentIndex] = drift[componentIndex].add(stateVariable.sub(stateVariablePrevious).div(timeStep));
        }
        for (componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            drift[this.getNumberOfLibors() + componentIndex] = variances[componentIndex];
        }
        for (componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            periodStart = liborPeriodDiscretization.getTime(componentIndex);
            periodLength = liborPeriodDiscretization.getTimeStep(componentIndex);
            periodEnd = periodStart + periodLength;
            periodStartPrevious = liborPeriodDiscretizationPrevious.getTime(componentIndex);
            periodLengthPrevious = liborPeriodDiscretizationPrevious.getTimeStep(componentIndex);
            double periodEndPrevious = periodStartPrevious + periodLengthPrevious;
            if (periodStartPrevious == periodStart && periodEndPrevious == periodEnd) continue;
            stateVariablePrevious = this.getIntegratedVariance(timeIndex, periodStartPrevious, periodEndPrevious);
            stateVariable = this.getIntegratedVariance(timeIndex, periodStart, periodEnd);
            if (Double.isNaN(stateVariable.getAverage()) || Double.isNaN(stateVariablePrevious.getAverage())) {
                throw new IllegalArgumentException();
            }
            drift[this.getNumberOfLibors() + componentIndex] = drift[this.getNumberOfLibors() + componentIndex].add(stateVariable.sub(stateVariablePrevious).div(timeStep));
        }
        return drift;
    }

    private RandomVariableInterface getIntegratedVariance(int timeIndex, double periodStart, double periodEnd) {
        TimeDiscretizationInterface liborPeriodTiscretization = this.getLiborPeriodDiscretization(this.getTime(timeIndex));
        int periodStartIndex = liborPeriodTiscretization.getTimeIndex(periodStart);
        int perirodEndIndex = liborPeriodTiscretization.getTimeIndex(periodEnd);
        if (periodStartIndex < 0) {
            periodStartIndex = -periodStartIndex - 1 - 1;
        }
        if (perirodEndIndex < 0) {
            perirodEndIndex = -perirodEndIndex - 1;
        }
        if (perirodEndIndex != periodStartIndex + 1) {
            throw new IllegalArgumentException();
        }
        RandomVariableInterface integratedVariance = null;
        try {
            integratedVariance = this.getProcess().getProcessValue(timeIndex, this.getNumberOfLibors() + periodStartIndex);
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return integratedVariance;
    }

    private double getWeightForTenorRefinement(double periodStartPrevious, double periodEndPrevious, double periodStart, double periodEnd) {
        TimeDiscretizationInterface numeriareDiscretization = this.liborPeriodDiscretizations[0];
        int periodStartPreviousIndex = numeriareDiscretization.getTimeIndex(periodStartPrevious);
        int periodEndPreviousIndex = numeriareDiscretization.getTimeIndex(periodEndPrevious);
        int periodStartIndex = numeriareDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = numeriareDiscretization.getTimeIndex(periodEnd);
        if (periodStartIndex < 0) {
            periodStartIndex = -periodStartIndex - 1;
        }
        if (periodEndIndex < 0) {
            periodEndIndex = -periodEndIndex - 1 - 1;
        }
        double weight1 = 0.0;
        for (int periodIndex = periodStartPreviousIndex; periodIndex < periodEndPreviousIndex; ++periodIndex) {
            double deltaT = this.covarianceModel.getScaledTenorTime(numeriareDiscretization.getTime(periodIndex), numeriareDiscretization.getTime(periodIndex + 1));
            double deltaTSum = this.covarianceModel.getScaledTenorTime(periodStartPrevious, numeriareDiscretization.getTime(periodIndex + 1));
            weight1 += deltaT * deltaTSum;
        }
        double weight2 = 0.0;
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            double deltaT = this.covarianceModel.getScaledTenorTime(numeriareDiscretization.getTime(periodIndex), numeriareDiscretization.getTime(periodIndex + 1));
            double deltaTSum = this.covarianceModel.getScaledTenorTime(periodStartPrevious, numeriareDiscretization.getTime(periodIndex + 1));
            weight2 += deltaT * deltaTSum;
        }
        if (weight1 > 0.0) {
            return weight2 / this.covarianceModel.getScaledTenorTime(periodStart, periodEnd) - weight1 / this.covarianceModel.getScaledTenorTime(periodStartPrevious, periodEndPrevious);
        }
        return weight2 / this.covarianceModel.getScaledTenorTime(periodStart, periodEnd);
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface zero = this.getProcess().getStochasticDriver().getRandomVariableForConstant(0.0);
        if (componentIndex < this.getNumberOfLibors()) {
            TimeDiscretizationInterface liborPeriodDiscretization = this.getLiborPeriodDiscretization(this.getTime(timeIndex));
            TimeDiscretizationInterface liborPeriodDiscretizationNext = this.getLiborPeriodDiscretization(this.getTime(timeIndex + 1));
            double periodStart = liborPeriodDiscretizationNext.getTime(componentIndex);
            double periodEnd = liborPeriodDiscretizationNext.getTime(componentIndex + 1);
            RandomVariableInterface[] factorLoadingVector = this.covarianceModel.getFactorLoading(this.getTime(timeIndex), periodStart, periodEnd, liborPeriodDiscretization, realizationAtTimeIndex, this);
            return factorLoadingVector;
        }
        Object[] zeros = new RandomVariableInterface[this.getProcess().getStochasticDriver().getNumberOfFactors()];
        Arrays.fill(zeros, zero);
        return zeros;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    private TimeDiscretizationInterface getLiborPeriodDiscretization(double time) {
        double firstTime;
        ArrayList<Double> tenorTimes = new ArrayList<Double>();
        double lastTime = firstTime = this.liborPeriodDiscretizations[0].getTime(this.liborPeriodDiscretizations[0].getTimeIndexNearestLessOrEqual(time));
        tenorTimes.add(firstTime);
        for (int discretizationLevelIndex = 0; discretizationLevelIndex < this.liborPeriodDiscretizations.length; ++discretizationLevelIndex) {
            int tentorIntervallStartIndex = this.liborPeriodDiscretizations[discretizationLevelIndex].getTimeIndexNearestLessOrEqual(lastTime) + 1;
            for (int tenorIntervall = 0; tenorIntervall < this.numberOfDiscretizationIntervalls[discretizationLevelIndex] && tentorIntervallStartIndex + tenorIntervall < this.liborPeriodDiscretizations[discretizationLevelIndex].getNumberOfTimes(); ++tenorIntervall) {
                lastTime = this.liborPeriodDiscretizations[discretizationLevelIndex].getTime(tentorIntervallStartIndex + tenorIntervall);
                lastTime = this.liborPeriodDiscretizations[0].getTime(this.liborPeriodDiscretizations[0].getTimeIndexNearestLessOrEqual(lastTime));
                tenorTimes.add(lastTime);
            }
        }
        return new TimeDiscretization(tenorTimes);
    }

    public RandomVariableInterface getStateVariableForPeriod(TimeDiscretizationInterface liborPeriodDiscretization, RandomVariableInterface[] stateVariables, double periodStart, double periodEnd) {
        double tenor;
        RandomVariableInterface integratedVariance;
        double tenorRefinementWeight;
        RandomVariableInterface stateVariable;
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariableInterface stateVariableSum = this.getProcess().getStochasticDriver().getRandomVariableForConstant(0.0);
        if (periodStartIndex < 0) {
            if ((periodStartIndex = -periodStartIndex - 1) >= liborPeriodDiscretization.getNumberOfTimes()) {
                throw new IllegalArgumentException();
            }
            stateVariable = stateVariables[periodStartIndex - 1];
            double shortPeriodEnd = liborPeriodDiscretization.getTime(periodStartIndex);
            tenorRefinementWeight = this.getWeightForTenorRefinement(liborPeriodDiscretization.getTime(periodStartIndex - 1), shortPeriodEnd, periodStart, shortPeriodEnd);
            integratedVariance = stateVariables[this.getNumberOfLibors() + periodStartIndex - 1];
            tenor = this.covarianceModel.getScaledTenorTime(periodStart, shortPeriodEnd);
            stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), tenor);
        }
        if (periodEndIndex < 0) {
            periodEndIndex = -periodEndIndex - 1;
            stateVariable = stateVariables[periodEndIndex - 1];
            double shortPeriodStart = liborPeriodDiscretization.getTime(periodEndIndex - 1);
            tenorRefinementWeight = this.getWeightForTenorRefinement(shortPeriodStart, liborPeriodDiscretization.getTime(periodEndIndex), shortPeriodStart, periodEnd);
            integratedVariance = stateVariables[this.getNumberOfLibors() + periodEndIndex - 1];
            tenor = this.covarianceModel.getScaledTenorTime(shortPeriodStart, periodEnd);
            stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), tenor);
            --periodEndIndex;
        }
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            RandomVariableInterface stateVariable2 = stateVariables[periodIndex];
            double tenor2 = this.covarianceModel.getScaledTenorTime(liborPeriodDiscretization.getTime(periodIndex), liborPeriodDiscretization.getTime(periodIndex + 1));
            stateVariableSum = stateVariableSum.addProduct(stateVariable2, tenor2);
        }
        double tenor3 = this.covarianceModel.getScaledTenorTime(periodStart, periodEnd);
        stateVariableSum = stateVariableSum.div(tenor3);
        return stateVariableSum;
    }

    public RandomVariableInterface getLIBORForStateVariable(TimeDiscretizationInterface liborPeriodDiscretization, RandomVariableInterface[] stateVariables, double periodStart, double periodEnd) {
        RandomVariableInterface stateVariable = this.getStateVariableForPeriod(liborPeriodDiscretization, stateVariables, periodStart, periodEnd);
        stateVariable = stateVariable.mult(periodEnd - periodStart).add(Math.log(1.0 + this.forwardRateCurve.getForward(null, periodStart) * (periodEnd - periodStart)));
        RandomVariableInterface libor = stateVariable.exp().sub(1.0).div(periodEnd - periodStart);
        return null;
    }

    public RandomVariableInterface getStateVariable(int timeIndex, double periodStart, double periodEnd) {
        double time = this.getTimeDiscretization().getTime(timeIndex);
        TimeDiscretizationInterface liborPeriodDiscretization = this.getLiborPeriodDiscretization(time);
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariableInterface stateVariableSum = null;
        try {
            RandomVariableInterface integratedVariance;
            double tenorRefinementWeight;
            RandomVariableInterface stateVariable;
            stateVariableSum = this.getProcess().getStochasticDriver().getRandomVariableForConstant(0.0);
            if (periodStartIndex < 0) {
                if ((periodStartIndex = -periodStartIndex - 1) >= liborPeriodDiscretization.getNumberOfTimes()) {
                    throw new IllegalArgumentException();
                }
                stateVariable = this.getProcessValue(timeIndex, periodStartIndex - 1);
                double shortPeriodEnd = liborPeriodDiscretization.getTime(periodStartIndex);
                tenorRefinementWeight = this.getWeightForTenorRefinement(liborPeriodDiscretization.getTime(periodStartIndex - 1), shortPeriodEnd, periodStart, shortPeriodEnd);
                integratedVariance = this.getIntegratedVariance(timeIndex, liborPeriodDiscretization.getTime(periodStartIndex - 1), liborPeriodDiscretization.getTime(periodStartIndex));
                stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), this.covarianceModel.getScaledTenorTime(periodStart, shortPeriodEnd));
            }
            if (periodEndIndex < 0) {
                periodEndIndex = -periodEndIndex - 1;
                stateVariable = this.getProcessValue(timeIndex, periodEndIndex - 1);
                double shortPeriodStart = liborPeriodDiscretization.getTime(periodEndIndex - 1);
                tenorRefinementWeight = this.getWeightForTenorRefinement(shortPeriodStart, liborPeriodDiscretization.getTime(periodEndIndex), shortPeriodStart, periodEnd);
                integratedVariance = this.getIntegratedVariance(timeIndex, liborPeriodDiscretization.getTime(periodEndIndex - 1), liborPeriodDiscretization.getTime(periodEndIndex));
                stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), this.covarianceModel.getScaledTenorTime(shortPeriodStart, periodEnd));
                --periodEndIndex;
            }
            for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
                RandomVariableInterface stateVariable2 = this.getProcessValue(timeIndex, periodIndex);
                stateVariableSum = stateVariableSum.addProduct(stateVariable2, this.covarianceModel.getScaledTenorTime(liborPeriodDiscretization.getTime(periodIndex), liborPeriodDiscretization.getTime(periodIndex + 1)));
            }
            stateVariableSum = stateVariableSum.div(this.covarianceModel.getScaledTenorTime(periodStart, periodEnd));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return stateVariableSum;
    }

    @Override
    public RandomVariableInterface getLIBOR(double time, double periodStart, double periodEnd) {
        int timeIndex = this.getProcess().getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1 - 1;
        }
        return this.getLIBOR(timeIndex, periodStart, periodEnd);
    }

    public RandomVariableInterface getLIBOR(int timeIndex, double periodStart, double periodEnd) {
        RandomVariableInterface stateVariable = this.getStateVariable(timeIndex, periodStart, periodEnd);
        double initialValue = Math.log(1.0 + this.forwardRateCurve.getForward(this.curveModel, periodStart) * this.forwardRateCurve.getPaymentOffset(periodStart)) / this.forwardRateCurve.getPaymentOffset(periodStart);
        double tenorTime = this.covarianceModel.getScaledTenorTime(periodStart, periodEnd);
        stateVariable = stateVariable.mult(tenorTime).add(initialValue * (periodEnd - periodStart));
        RandomVariableInterface libor = stateVariable.exp().sub(1.0).div(periodEnd - periodStart);
        return libor;
    }

    @Override
    public int getNumberOfComponents() {
        return 2 * this.getLiborPeriodDiscretization(0.0).getNumberOfTimeSteps();
    }

    public int getNumberOfLibors() {
        return this.getLiborPeriodDiscretization(0.0).getNumberOfTimeSteps();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnalyticModelInterface getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurveInterface getDiscountCurve() {
        return this.discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    @Override
    public TermStructureModelInterface getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        CalibrationItem[] calibrationItems = null;
        Map<String, ?> properties = null;
        TermStructureCovarianceModelInterface covarianceModel = this.covarianceModel;
        if (dataModified.containsKey("covarianceModel")) {
            covarianceModel = (TermStructureCovarianceModelInterface)dataModified.get("covarianceModel");
        }
        return new LIBORMarketModelWithTenorRefinement(this.liborPeriodDiscretizations, this.numberOfDiscretizationIntervalls, this.curveModel, this.forwardRateCurve, this.discountCurve, covarianceModel, calibrationItems, properties);
    }

    public TermStructureCovarianceModelInterface getCovarianceModel() {
        return this.covarianceModel;
    }

    public static class CalibrationItem {
        public final AbstractLIBORMonteCarloProduct calibrationProduct;
        public final double calibrationTargetValue;
        public final double calibrationWeight;

        public CalibrationItem(AbstractLIBORMonteCarloProduct calibrationProduct, double calibrationTargetValue, double calibrationWeight) {
            this.calibrationProduct = calibrationProduct;
            this.calibrationTargetValue = calibrationTargetValue;
            this.calibrationWeight = calibrationWeight;
        }

        public String toString() {
            return "CalibrationItem [calibrationProduct=" + this.calibrationProduct + ", calibrationTargetValue=" + this.calibrationTargetValue + ", calibrationWeight=" + this.calibrationWeight + "]";
        }
    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }
}

