/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractSwaptionMarketData;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORMarketModel
extends AbstractModel
implements LIBORMarketModelInterface {
    private final TimeDiscretizationInterface liborPeriodDiscretization;
    private String forwardCurveName;
    private AnalyticModelInterface curveModel;
    private ForwardCurveInterface forwardRateCurve;
    private DiscountCurveInterface discountCurve;
    private final AbstractRandomVariableFactory randomVariableFactory;
    private AbstractLIBORCovarianceModel covarianceModel;
    private AbstractSwaptionMarketData swaptionMarketData;
    private Driftapproximation driftApproximationMethod = Driftapproximation.EULER;
    private Measure measure = Measure.SPOT;
    private StateSpace stateSpace = StateSpace.LOGNORMAL;
    private double liborCap = 100000.0;
    private double[][][] integratedLIBORCovariance;
    private final Object integratedLIBORCovarianceLazyInitLock = new Object();
    private final ConcurrentHashMap<Integer, RandomVariableInterface> numeraires;
    private AbstractProcessInterface numerairesProcess = null;

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, AnalyticModelInterface analyticModel, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractRandomVariableFactory randomVariableFactory, AbstractLIBORCovarianceModel covarianceModel, CalibrationItem[] calibrationItems, Map<String, ?> properties) throws CalculationException {
        if (properties != null && properties.containsKey("measure")) {
            this.measure = Measure.valueOf(((String)properties.get("measure")).toUpperCase());
        }
        if (properties != null && properties.containsKey("stateSpace")) {
            this.stateSpace = StateSpace.valueOf(((String)properties.get("stateSpace")).toUpperCase());
        }
        if (properties != null && properties.containsKey("liborCap")) {
            this.liborCap = (Double)properties.get("liborCap");
        }
        Map calibrationParameters = null;
        if (properties != null && properties.containsKey("calibrationParameters")) {
            calibrationParameters = (Map)properties.get("calibrationParameters");
        }
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.curveModel = analyticModel;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.randomVariableFactory = randomVariableFactory;
        this.covarianceModel = covarianceModel;
        double[] times = new double[liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < times.length; ++i) {
            times[i] = liborPeriodDiscretization.getTime(i);
        }
        if (calibrationItems != null && calibrationItems.length > 0) {
            AbstractLIBORCovarianceModelParametric covarianceModelParametric = null;
            try {
                covarianceModelParametric = (AbstractLIBORCovarianceModelParametric)covarianceModel;
            }
            catch (Exception e) {
                throw new ClassCastException("Calibration is currently restricted to parametric covariance models (AbstractLIBORCovarianceModelParametric).");
            }
            AbstractLIBORMonteCarloProduct[] calibrationProducts = new AbstractLIBORMonteCarloProduct[calibrationItems.length];
            double[] calibrationTargetValues = new double[calibrationItems.length];
            double[] calibrationWeights = new double[calibrationItems.length];
            for (int i = 0; i < calibrationTargetValues.length; ++i) {
                calibrationProducts[i] = calibrationItems[i].calibrationProduct;
                calibrationTargetValues[i] = calibrationItems[i].calibrationTargetValue;
                calibrationWeights[i] = calibrationItems[i].calibrationWeight;
            }
            this.covarianceModel = covarianceModelParametric.getCloneCalibrated(this, calibrationProducts, calibrationTargetValues, calibrationWeights, calibrationParameters);
        }
        this.numeraires = new ConcurrentHashMap();
    }

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, AnalyticModelInterface analyticModel, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel, CalibrationItem[] calibrationItems, Map<String, ?> properties) throws CalculationException {
        this(liborPeriodDiscretization, analyticModel, forwardRateCurve, discountCurve, new RandomVariableFactory(), covarianceModel, calibrationItems, properties);
    }

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, AbstractLIBORCovarianceModel covarianceModel) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, (DiscountCurveInterface)new DiscountCurveFromForwardCurve(forwardRateCurve), covarianceModel, new CalibrationItem[0], null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, new CalibrationItem[0], null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, AbstractLIBORCovarianceModel covarianceModel, AbstractSwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, (DiscountCurveInterface)new DiscountCurveFromForwardCurve(forwardRateCurve), covarianceModel, swaptionMarketData, null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel, AbstractSwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, swaptionMarketData, null);
    }

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel, AbstractSwaptionMarketData swaptionMarketData, Map<String, ?> properties) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, LIBORMarketModel.getCalibrationItems(liborPeriodDiscretization, forwardRateCurve, swaptionMarketData, (properties == null || properties.get("stateSpace") == null || ((String)properties.get("stateSpace")).toUpperCase().equals(StateSpace.LOGNORMAL.name())) && AbstractLIBORCovarianceModelParametric.class.isAssignableFrom(covarianceModel.getClass())), properties);
    }

    public LIBORMarketModel(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, AbstractLIBORCovarianceModel covarianceModel, CalibrationItem[] calibrationItems, Map<String, ?> properties) throws CalculationException {
        this(liborPeriodDiscretization, null, forwardRateCurve, discountCurve, covarianceModel, calibrationItems, properties);
    }

    private static CalibrationItem[] getCalibrationItems(TimeDiscretizationInterface liborPeriodDiscretization, ForwardCurveInterface forwardCurve, AbstractSwaptionMarketData swaptionMarketData, boolean isUseAnalyticApproximation) {
        if (swaptionMarketData == null) {
            return null;
        }
        TimeDiscretizationInterface optionMaturities = swaptionMarketData.getOptionMaturities();
        TimeDiscretizationInterface tenor = swaptionMarketData.getTenor();
        double swapPeriodLength = swaptionMarketData.getSwapPeriodLength();
        ArrayList<CalibrationItem> calibrationItems = new ArrayList<CalibrationItem>();
        for (int exerciseIndex = 0; exerciseIndex <= optionMaturities.getNumberOfTimeSteps(); ++exerciseIndex) {
            for (int tenorIndex = 0; tenorIndex <= tenor.getNumberOfTimeSteps() - exerciseIndex; ++tenorIndex) {
                AbstractLIBORMonteCarloProduct swaption;
                double exerciseDate = optionMaturities.getTime(exerciseIndex);
                double swapLength = tenor.getTime(tenorIndex);
                if (liborPeriodDiscretization.getTimeIndex(exerciseDate) < 0 || liborPeriodDiscretization.getTimeIndex(exerciseDate + swapLength) <= liborPeriodDiscretization.getTimeIndex(exerciseDate)) continue;
                int numberOfPeriods = (int)(swapLength / swapPeriodLength);
                double[] fixingDates = new double[numberOfPeriods];
                double[] paymentDates = new double[numberOfPeriods];
                double[] swapTenorTimes = new double[numberOfPeriods + 1];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    fixingDates[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                    paymentDates[periodStartIndex] = exerciseDate + (double)(periodStartIndex + 1) * swapPeriodLength;
                    swapTenorTimes[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                }
                swapTenorTimes[numberOfPeriods] = exerciseDate + (double)numberOfPeriods * swapPeriodLength;
                RegularSchedule swapTenor = new RegularSchedule(new TimeDiscretization(swapTenorTimes));
                double swaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve, null);
                double[] swaprates = new double[numberOfPeriods];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    swaprates[periodStartIndex] = swaprate;
                }
                if (isUseAnalyticApproximation) {
                    swaption = new SwaptionAnalyticApproximation(swaprate, swapTenorTimes, SwaptionAnalyticApproximation.ValueUnit.VOLATILITY);
                    double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                    calibrationItems.add(new CalibrationItem(swaption, impliedVolatility, 1.0));
                    continue;
                }
                swaption = new SwaptionSimple(swaprate, swapTenorTimes, SwaptionSimple.ValueUnit.VALUE);
                double forwardSwaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve);
                double swapAnnuity = SwapAnnuity.getSwapAnnuity((ScheduleInterface)swapTenor, forwardCurve);
                double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                double targetValue = AnalyticFormulas.blackModelSwaptionValue(forwardSwaprate, impliedVolatility, exerciseDate, swaprate, swapAnnuity);
                calibrationItems.add(new CalibrationItem(swaption, targetValue, 1.0));
            }
        }
        return calibrationItems.toArray(new CalibrationItem[calibrationItems.size()]);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        RandomVariableInterface numeraire;
        int timeIndex = this.getLiborPeriodIndex(time);
        if (timeIndex < 0) {
            int upperIndex = -timeIndex - 1;
            int lowerIndex = upperIndex - 1;
            if (lowerIndex < 0) {
                throw new IllegalArgumentException("Numeraire requested for time " + time + ". Unsupported");
            }
            double alpha = (time - this.getLiborPeriod(lowerIndex)) / (this.getLiborPeriod(upperIndex) - this.getLiborPeriod(lowerIndex));
            RandomVariableInterface numeraire2 = this.getNumeraire(this.getLiborPeriod(upperIndex)).log().mult(alpha).add(this.getNumeraire(this.getLiborPeriod(lowerIndex)).log().mult(1.0 - alpha)).exp();
            if (this.discountCurve != null) {
                double deterministicNumeraireAdjustment = numeraire2.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, time);
                numeraire2 = numeraire2.mult(deterministicNumeraireAdjustment);
            }
            return numeraire2;
        }
        if (this.getProcess() != this.numerairesProcess) {
            this.numeraires.clear();
            this.numerairesProcess = this.getProcess();
        }
        if ((numeraire = this.numeraires.get(timeIndex)) == null) {
            int lastLiborIndex;
            int firstLiborIndex;
            numeraire = this.getRandomVariableForConstant(1.0);
            if (this.measure == Measure.TERMINAL) {
                firstLiborIndex = this.getLiborPeriodIndex(time);
                if (firstLiborIndex < 0) {
                    throw new CalculationException("Simulation time discretization not part of forward rate tenor discretization.");
                }
                lastLiborIndex = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
            } else if (this.measure == Measure.SPOT) {
                firstLiborIndex = 0;
                lastLiborIndex = this.getLiborPeriodIndex(time) - 1;
            } else {
                throw new CalculationException("Numeraire not implemented for specified measure.");
            }
            for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
                RandomVariableInterface libor = this.getLIBOR(this.getTimeIndex(Math.min(time, this.liborPeriodDiscretization.getTime(liborIndex))), liborIndex);
                double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
                numeraire = this.measure == Measure.SPOT ? numeraire.accrue(libor, periodLength) : numeraire.discount(libor, periodLength);
            }
            this.numeraires.put(timeIndex, numeraire);
        }
        if (this.discountCurve != null) {
            double deterministicNumeraireAdjustment = numeraire.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        double[] liborInitialStates = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int timeIndex = 0; timeIndex < this.liborPeriodDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double rate = this.forwardRateCurve.getForward(this.curveModel, this.liborPeriodDiscretization.getTime(timeIndex));
            liborInitialStates[timeIndex] = this.stateSpace == StateSpace.LOGNORMAL ? Math.log(Math.max(rate, 0.0)) : rate;
        }
        RandomVariableInterface[] initialStateRandomVariable = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            initialStateRandomVariable[componentIndex] = this.getRandomVariableForConstant(liborInitialStates[componentIndex]);
        }
        return initialStateRandomVariable;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        int factorIndex;
        RandomVariableInterface[] factorLoading;
        RandomVariableInterface oneStepMeasureTransform;
        RandomVariableInterface libor;
        double periodLength;
        int componentIndex;
        double time = this.getTime(timeIndex);
        int firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
        if (firstLiborIndex < 0) {
            firstLiborIndex = -firstLiborIndex - 1 + 1;
        }
        RandomVariableInterface zero = this.getRandomVariableForConstant(0.0);
        RandomVariableInterface[] drift = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex2 = firstLiborIndex; componentIndex2 < this.getNumberOfComponents(); ++componentIndex2) {
            drift[componentIndex2] = zero;
        }
        RandomVariableInterface[] covarianceFactorSums = new RandomVariableInterface[this.getNumberOfFactors()];
        for (int factorIndex2 = 0; factorIndex2 < this.getNumberOfFactors(); ++factorIndex2) {
            covarianceFactorSums[factorIndex2] = zero;
        }
        if (this.measure == Measure.SPOT) {
            for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                periodLength = this.liborPeriodDiscretization.getTimeStep(componentIndex);
                libor = realizationAtTimeIndex[componentIndex];
                oneStepMeasureTransform = this.getRandomVariableForConstant(periodLength).discount(libor, periodLength);
                if (this.stateSpace == StateSpace.LOGNORMAL) {
                    oneStepMeasureTransform = oneStepMeasureTransform.mult(libor);
                }
                factorLoading = this.getFactorLoading(timeIndex, componentIndex, realizationAtTimeIndex);
                for (factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                    covarianceFactorSums[factorIndex] = covarianceFactorSums[factorIndex].add(oneStepMeasureTransform.mult(factorLoading[factorIndex]));
                    drift[componentIndex] = drift[componentIndex].addProduct(covarianceFactorSums[factorIndex], factorLoading[factorIndex]);
                }
            }
        } else if (this.measure == Measure.TERMINAL) {
            for (componentIndex = this.getNumberOfComponents() - 1; componentIndex >= firstLiborIndex; --componentIndex) {
                periodLength = this.liborPeriodDiscretization.getTimeStep(componentIndex);
                libor = realizationAtTimeIndex[componentIndex];
                oneStepMeasureTransform = this.getRandomVariableForConstant(periodLength).discount(libor, periodLength);
                if (this.stateSpace == StateSpace.LOGNORMAL) {
                    oneStepMeasureTransform = oneStepMeasureTransform.mult(libor);
                }
                factorLoading = this.getFactorLoading(timeIndex, componentIndex, realizationAtTimeIndex);
                for (factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                    drift[componentIndex] = drift[componentIndex].addProduct(covarianceFactorSums[factorIndex], factorLoading[factorIndex]);
                    covarianceFactorSums[factorIndex] = covarianceFactorSums[factorIndex].sub(oneStepMeasureTransform.mult(factorLoading[factorIndex]));
                }
            }
        }
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                RandomVariableInterface variance = this.covarianceModel.getCovariance(this.getTime(timeIndex), componentIndex, componentIndex, realizationAtTimeIndex);
                drift[componentIndex] = drift[componentIndex].addProduct(variance, -0.5);
            }
        }
        return drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex) {
        return this.covarianceModel.getFactorLoading(this.getTime(timeIndex), this.getLiborPeriod(componentIndex), realizationAtTimeIndex);
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        RandomVariableInterface value = randomVariable;
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            value = value.exp();
        }
        if (!Double.isInfinite(this.liborCap)) {
            value = value.cap(this.liborCap);
        }
        return value;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        RandomVariableInterface value = randomVariable;
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            value = value.log();
        }
        return value;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public Driftapproximation getDriftApproximationMethod() {
        return this.driftApproximationMethod;
    }

    @Override
    public RandomVariableInterface getLIBOR(double time, double periodStart, double periodEnd) throws CalculationException {
        int periodStartIndex = this.getLiborPeriodIndex(periodStart);
        int periodEndIndex = this.getLiborPeriodIndex(periodEnd);
        if (periodEndIndex < 0) {
            int previousEndIndex = -periodEndIndex - 1 - 1;
            double previousEndTime = this.getLiborPeriod(previousEndIndex);
            double nextEndTime = this.getLiborPeriod(previousEndIndex + 1);
            RandomVariableInterface liborLongPeriod = this.getLIBOR(time, periodStart, nextEndTime);
            RandomVariableInterface liborShortPeriod = this.getLIBOR(time, previousEndTime, nextEndTime);
            RandomVariableInterface libor = liborLongPeriod.mult(nextEndTime - periodStart).add(1.0).div(liborShortPeriod.mult(nextEndTime - previousEndTime).add(1.0).log().mult((nextEndTime - periodEnd) / (nextEndTime - previousEndTime)).exp()).sub(1.0).div(periodEnd - periodStart);
            double analyticLibor = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousEndTime, periodEnd - previousEndTime);
            double analyticLiborShortPeriod = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousEndTime, nextEndTime - previousEndTime);
            double analyticInterpolatedOnePlusLiborDt = (1.0 + analyticLiborShortPeriod * (nextEndTime - previousEndTime)) / Math.exp(Math.log(1.0 + analyticLiborShortPeriod * (nextEndTime - previousEndTime)) * (nextEndTime - periodEnd) / (nextEndTime - previousEndTime));
            double analyticOnePlusLiborDt = 1.0 + analyticLibor * (periodEnd - previousEndTime);
            double adjustment = analyticOnePlusLiborDt / analyticInterpolatedOnePlusLiborDt;
            libor = libor.mult(periodEnd - periodStart).add(1.0).mult(adjustment).sub(1.0).div(periodEnd - periodStart);
            return libor;
        }
        if (periodStartIndex < 0) {
            int previousStartIndex = -periodStartIndex - 1 - 1;
            double previousStartTime = this.getLiborPeriod(previousStartIndex);
            double nextStartTime = this.getLiborPeriod(previousStartIndex + 1);
            RandomVariableInterface liborLongPeriod = this.getLIBOR(time, previousStartTime, periodEnd);
            RandomVariableInterface liborShortPeriod = this.getLIBOR(time, previousStartTime, nextStartTime);
            RandomVariableInterface libor = liborLongPeriod.mult(periodEnd - previousStartTime).add(1.0).div(liborShortPeriod.mult(nextStartTime - previousStartTime).add(1.0).log().mult((periodStart - previousStartTime) / (nextStartTime - previousStartTime)).exp()).sub(1.0).div(periodEnd - periodStart);
            double analyticLibor = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousStartTime, nextStartTime - periodStart);
            double analyticLiborShortPeriod = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousStartTime, nextStartTime - previousStartTime);
            double analyticInterpolatedOnePlusLiborDt = (1.0 + analyticLiborShortPeriod * (nextStartTime - previousStartTime)) / Math.exp(Math.log(1.0 + analyticLiborShortPeriod * (nextStartTime - previousStartTime)) * (nextStartTime - periodStart) / (nextStartTime - previousStartTime));
            double analyticOnePlusLiborDt = 1.0 + analyticLibor * (periodStart - previousStartTime);
            double adjustment = analyticOnePlusLiborDt / analyticInterpolatedOnePlusLiborDt;
            libor = libor.mult(periodEnd - periodStart).add(1.0).div(adjustment).sub(1.0).div(periodEnd - periodStart);
            return libor;
        }
        if (periodStartIndex < 0 || periodEndIndex < 0) {
            throw new AssertionError((Object)"LIBOR requested outside libor discretization points and interpolation was not performed.");
        }
        int timeIndex = this.getTimeIndex(time = Math.min(time, periodStart));
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 2;
        }
        if (periodStartIndex + 1 == periodEndIndex) {
            return this.getLIBOR(timeIndex, periodStartIndex);
        }
        RandomVariableInterface accrualAccount = this.getProcess().getStochasticDriver().getRandomVariableForConstant(1.0);
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            double subPeriodLength = this.getLiborPeriod(periodIndex + 1) - this.getLiborPeriod(periodIndex);
            RandomVariableInterface liborOverSubPeriod = this.getLIBOR(timeIndex, periodIndex);
            accrualAccount = accrualAccount.accrue(liborOverSubPeriod, subPeriodLength);
        }
        RandomVariableInterface libor = accrualAccount.sub(1.0).div(periodEnd - periodStart);
        return libor;
    }

    @Override
    public RandomVariableInterface getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        return this.getProcessValue(timeIndex, liborIndex);
    }

    @Override
    public int getNumberOfComponents() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public int getNumberOfLibors() {
        return this.getNumberOfComponents();
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        if (timeIndex >= this.liborPeriodDiscretization.getNumberOfTimes() || timeIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Index for LIBOR period discretization out of bounds: " + timeIndex + ".");
        }
        return this.liborPeriodDiscretization.getTime(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborPeriodDiscretization.getTimeIndex(time);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][][] getIntegratedLIBORCovariance() {
        Object object = this.integratedLIBORCovarianceLazyInitLock;
        synchronized (object) {
            if (this.integratedLIBORCovariance == null) {
                int timeIndex;
                TimeDiscretizationInterface liborPeriodDiscretization = this.getLiborPeriodDiscretization();
                TimeDiscretizationInterface simulationTimeDiscretization = this.getCovarianceModel().getTimeDiscretization();
                this.integratedLIBORCovariance = new double[simulationTimeDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()];
                for (timeIndex = 0; timeIndex < simulationTimeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
                    double dt = simulationTimeDiscretization.getTime(timeIndex + 1) - simulationTimeDiscretization.getTime(timeIndex);
                    RandomVariableInterface[][] factorLoadings = new RandomVariableInterface[liborPeriodDiscretization.getNumberOfTimeSteps()][];
                    for (int componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
                        factorLoadings[componentIndex] = this.getCovarianceModel().getFactorLoading(timeIndex, componentIndex, (RandomVariableInterface[])null);
                    }
                    for (int componentIndex1 = 0; componentIndex1 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex1) {
                        RandomVariableInterface[] factorLoadingOfComponent1 = factorLoadings[componentIndex1];
                        for (int componentIndex2 = componentIndex1; componentIndex2 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex2) {
                            double integratedLIBORCovarianceValue = 0.0;
                            if (this.getLiborPeriod(componentIndex1) > this.getTime(timeIndex)) {
                                RandomVariableInterface[] factorLoadingOfComponent2 = factorLoadings[componentIndex2];
                                for (int factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                                    integratedLIBORCovarianceValue += factorLoadingOfComponent1[factorIndex].get(0) * factorLoadingOfComponent2[factorIndex].get(0) * dt;
                                }
                            }
                            this.integratedLIBORCovariance[timeIndex][componentIndex1][componentIndex2] = integratedLIBORCovarianceValue;
                        }
                    }
                }
                for (timeIndex = 1; timeIndex < simulationTimeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
                    double[][] prevIntegratedLIBORCovariance = this.integratedLIBORCovariance[timeIndex - 1];
                    double[][] thisIntegratedLIBORCovariance = this.integratedLIBORCovariance[timeIndex];
                    for (int componentIndex1 = 0; componentIndex1 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex1) {
                        for (int componentIndex2 = componentIndex1; componentIndex2 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex2) {
                            thisIntegratedLIBORCovariance[componentIndex1][componentIndex2] = prevIntegratedLIBORCovariance[componentIndex1][componentIndex2] + thisIntegratedLIBORCovariance[componentIndex1][componentIndex2];
                            thisIntegratedLIBORCovariance[componentIndex2][componentIndex1] = thisIntegratedLIBORCovariance[componentIndex1][componentIndex2];
                        }
                    }
                }
            }
        }
        return this.integratedLIBORCovariance;
    }

    public Object clone() {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("measure", this.measure.name());
            properties.put("stateSpace", this.stateSpace.name());
            return new LIBORMarketModel(this.getLiborPeriodDiscretization(), this.getAnalyticModel(), this.getForwardRateCurve(), this.getDiscountCurve(), this.covarianceModel, new CalibrationItem[0], properties);
        }
        catch (CalculationException e) {
            return null;
        }
    }

    @Override
    public AnalyticModelInterface getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurveInterface getDiscountCurve() {
        return this.discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    public AbstractSwaptionMarketData getSwaptionMarketData() {
        return this.swaptionMarketData;
    }

    @Override
    public AbstractLIBORCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public LIBORMarketModel getCloneWithModifiedCovarianceModel(AbstractLIBORCovarianceModel covarianceModel) {
        LIBORMarketModel model = (LIBORMarketModel)this.clone();
        model.covarianceModel = covarianceModel;
        return model;
    }

    @Override
    public LIBORMarketModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TimeDiscretizationInterface liborPeriodDiscretization = this.liborPeriodDiscretization;
        AnalyticModelInterface analyticModel = this.curveModel;
        ForwardCurveInterface forwardRateCurve = this.forwardRateCurve;
        DiscountCurveInterface discountCurve = this.discountCurve;
        AbstractLIBORCovarianceModel covarianceModel = this.covarianceModel;
        AbstractSwaptionMarketData swaptionMarketData = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("measure", this.measure.name());
        properties.put("stateSpace", this.stateSpace.name());
        if (dataModified.containsKey("liborPeriodDiscretization")) {
            liborPeriodDiscretization = (TimeDiscretizationInterface)dataModified.get("liborPeriodDiscretization");
        }
        if (dataModified.containsKey("forwardRateCurve")) {
            forwardRateCurve = (ForwardCurveInterface)dataModified.get("forwardRateCurve");
        }
        if (dataModified.containsKey("discountCurve")) {
            discountCurve = (DiscountCurveInterface)dataModified.get("discountCurve");
        }
        if (dataModified.containsKey("forwardRateShift")) {
            throw new RuntimeException("Forward rate shift clone currently disabled.");
        }
        if (dataModified.containsKey("covarianceModel")) {
            covarianceModel = (AbstractLIBORCovarianceModel)dataModified.get("covarianceModel");
        }
        if (dataModified.containsKey("swaptionMarketData")) {
            swaptionMarketData = (AbstractSwaptionMarketData)dataModified.get("swaptionMarketData");
        }
        LIBORMarketModel newModel = new LIBORMarketModel(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, swaptionMarketData, properties);
        newModel.curveModel = analyticModel;
        return newModel;
    }

    public String toString() {
        return "LIBORMarketModel [liborPeriodDiscretization=" + this.liborPeriodDiscretization + ", forwardCurveName=" + this.forwardCurveName + ", curveModel=" + this.curveModel + ", forwardRateCurve=" + this.forwardRateCurve + ", discountCurve=" + this.discountCurve + ", covarianceModel=" + this.covarianceModel + ", driftApproximationMethod=" + (Object)((Object)this.driftApproximationMethod) + ", measure=" + (Object)((Object)this.measure) + ", stateSpace=" + (Object)((Object)this.stateSpace) + "]";
    }

    public static class CalibrationItem {
        public final AbstractLIBORMonteCarloProduct calibrationProduct;
        public final double calibrationTargetValue;
        public final double calibrationWeight;

        public CalibrationItem(AbstractLIBORMonteCarloProduct calibrationProduct, double calibrationTargetValue, double calibrationWeight) {
            this.calibrationProduct = calibrationProduct;
            this.calibrationTargetValue = calibrationTargetValue;
            this.calibrationWeight = calibrationWeight;
        }

        public String toString() {
            return "CalibrationItem [calibrationProduct=" + this.calibrationProduct + ", calibrationTargetValue=" + this.calibrationTargetValue + ", calibrationWeight=" + this.calibrationWeight + "]";
        }
    }

    public static enum StateSpace {
        NORMAL,
        LOGNORMAL;

    }

    public static enum Measure {
        SPOT,
        TERMINAL;

    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }
}

