/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.stochastic.RandomVariableInterface;

public class BermudanOption
extends AbstractAssetMonteCarloProduct {
    private final double[] exerciseDates;
    private final double[] notionals;
    private final double[] strikes;
    private int orderOfRegressionPolynomial = 4;
    private boolean intrinsicValueAsBasisFunction = false;
    private ExerciseMethod exerciseMethod;
    private RandomVariableInterface lastValuationExerciseTime;

    public BermudanOption(double[] exerciseDates, double[] notionals, double[] strikes, ExerciseMethod exerciseMethod) {
        this.exerciseDates = exerciseDates;
        this.notionals = notionals;
        this.strikes = strikes;
        this.exerciseMethod = exerciseMethod;
    }

    public BermudanOption(double[] exerciseDates, double[] notionals, double[] strikes) {
        this(exerciseDates, notionals, strikes, ExerciseMethod.ESTIMATE_COND_EXPECTATION);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        if (this.exerciseMethod == ExerciseMethod.UPPER_BOUND_METHOD) {
            GoldenSectionSearch optimizer = new GoldenSectionSearch(-1.0, 1.0);
            while (!optimizer.isDone()) {
                double lambda = optimizer.getNextPoint();
                double value = this.getValues(evaluationTime, model, lambda).getAverage();
                optimizer.setValue(value);
            }
            return this.getValues(evaluationTime, model, optimizer.getBestPoint());
        }
        return this.getValues(evaluationTime, model, 0.0);
    }

    private RandomVariableInterface getValues(double evaluationTime, AssetModelMonteCarloSimulationInterface model, double lambda) throws CalculationException {
        RandomVariableInterface value = model.getRandomVariableForConstant(0.0);
        RandomVariableInterface exerciseTime = model.getRandomVariableForConstant(this.exerciseDates[this.exerciseDates.length - 1] + 1.0);
        for (int exerciseDateIndex = this.exerciseDates.length - 1; exerciseDateIndex >= 0; --exerciseDateIndex) {
            double exerciseDate = this.exerciseDates[exerciseDateIndex];
            double notional = this.notionals[exerciseDateIndex];
            double strike = this.strikes[exerciseDateIndex];
            RandomVariableInterface underlyingAtExercise = model.getAssetValue(exerciseDate, 0);
            RandomVariableInterface numeraireAtPayment = model.getNumeraire(exerciseDate);
            RandomVariableInterface monteCarloWeights = model.getMonteCarloWeights(exerciseDate);
            RandomVariableInterface valueOfPaymentsIfExercised = underlyingAtExercise.sub(strike).mult(notional).div(numeraireAtPayment).mult(monteCarloWeights);
            ArrayList<RandomVariableInterface> basisFunctions = this.intrinsicValueAsBasisFunction ? this.getRegressionBasisFunctions(underlyingAtExercise.sub(strike).floor(0.0)) : this.getRegressionBasisFunctions(underlyingAtExercise);
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(basisFunctions.toArray(new RandomVariableInterface[0]));
            RandomVariableInterface underlying = null;
            RandomVariableInterface trigger = null;
            switch (this.exerciseMethod) {
                case ESTIMATE_COND_EXPECTATION: {
                    RandomVariableInterface valueIfNotExcercisedEstimated = value.getConditionalExpectation(condExpEstimator);
                    underlying = valueOfPaymentsIfExercised;
                    trigger = valueIfNotExcercisedEstimated.sub(underlying);
                    break;
                }
                case UPPER_BOUND_METHOD: {
                    RandomVariableInterface martingale = model.getAssetValue(this.exerciseDates[exerciseDateIndex], 0).div(model.getNumeraire(this.exerciseDates[exerciseDateIndex]));
                    martingale = martingale.sub(martingale.getAverage()).mult(lambda);
                    if (exerciseDateIndex == this.exerciseDates.length - 1) {
                        value = value.sub(martingale);
                    }
                    underlying = valueOfPaymentsIfExercised.sub(martingale);
                    trigger = value.sub(underlying);
                }
            }
            value = value.barrier(trigger, value, underlying);
            exerciseTime = exerciseTime.barrier(trigger, exerciseTime, exerciseDate);
        }
        this.lastValuationExerciseTime = exerciseTime;
        RandomVariableInterface numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        return value;
    }

    public RandomVariableInterface getLastValuationExerciseTime() {
        return this.lastValuationExerciseTime;
    }

    public double[] getExerciseDates() {
        return this.exerciseDates;
    }

    public double[] getNotionals() {
        return this.notionals;
    }

    public double[] getStrikes() {
        return this.strikes;
    }

    private ArrayList<RandomVariableInterface> getRegressionBasisFunctions(RandomVariableInterface underlying) {
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        underlying = new RandomVariable(0.0, underlying.getRealizations());
        for (int powerOfRegressionMonomial = 0; powerOfRegressionMonomial <= this.orderOfRegressionPolynomial; ++powerOfRegressionMonomial) {
            basisFunctions.add(underlying.pow(powerOfRegressionMonomial));
        }
        return basisFunctions;
    }

    private ArrayList<RandomVariableInterface> getRegressionBasisFunctionsBinning(RandomVariableInterface underlying) {
        ArrayList<RandomVariableInterface> basisFunctions = new ArrayList<RandomVariableInterface>();
        underlying = new RandomVariable(0.0, underlying.getRealizations());
        int numberOfBins = 20;
        double[] values = underlying.getRealizations();
        Arrays.sort(values);
        for (int i = 0; i < numberOfBins; ++i) {
            double binLeft = values[(int)((double)i / (double)numberOfBins * (double)values.length)];
            RandomVariableInterface basisFunction = underlying.barrier(underlying.sub(binLeft), (RandomVariableInterface)new RandomVariable(1.0), 0.0);
            basisFunctions.add(basisFunction);
        }
        return basisFunctions;
    }

    public static enum ExerciseMethod {
        ESTIMATE_COND_EXPECTATION,
        UPPER_BOUND_METHOD;

    }
}

