/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Arrays;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloMultiAssetBlackScholesModel
extends AbstractModel
implements AssetModelMonteCarloSimulationInterface {
    private final double[] initialValues;
    private final double riskFreeRate;
    private final double[] volatilities;
    private final double[][] factorLoadings;
    private static final int seed = 3141;
    private final RandomVariableInterface[] initialStates;
    private final RandomVariableInterface[] drift;
    private final RandomVariableInterface[][] factorLoadingOnPaths;

    public MonteCarloMultiAssetBlackScholesModel(BrownianMotionInterface brownianMotion, double[] initialValues, double riskFreeRate, double[] volatilities, double[][] correlations) {
        ProcessEulerScheme process = new ProcessEulerScheme(brownianMotion);
        this.initialValues = initialValues;
        this.riskFreeRate = riskFreeRate;
        this.volatilities = volatilities;
        this.factorLoadings = LinearAlgebra.getFactorMatrix(correlations, correlations.length);
        this.initialStates = new RandomVariableInterface[this.getNumberOfComponents()];
        this.drift = new RandomVariableInterface[this.getNumberOfComponents()];
        this.factorLoadingOnPaths = new RandomVariableInterface[this.getNumberOfComponents()][];
        for (int underlyingIndex = 0; underlyingIndex < initialValues.length; ++underlyingIndex) {
            this.initialStates[underlyingIndex] = process.getStochasticDriver().getRandomVariableForConstant(Math.log(initialValues[underlyingIndex]));
            this.drift[underlyingIndex] = process.getStochasticDriver().getRandomVariableForConstant(riskFreeRate - volatilities[underlyingIndex] * volatilities[underlyingIndex] / 2.0);
            this.factorLoadingOnPaths[underlyingIndex] = new RandomVariableInterface[process.getNumberOfFactors()];
            for (int factorIndex = 0; factorIndex < process.getNumberOfFactors(); ++factorIndex) {
                this.factorLoadingOnPaths[underlyingIndex][factorIndex] = process.getStochasticDriver().getRandomVariableForConstant(volatilities[underlyingIndex] * this.factorLoadings[underlyingIndex][factorIndex]);
            }
        }
        process.setModel(this);
        this.setProcess(process);
    }

    public MonteCarloMultiAssetBlackScholesModel(TimeDiscretizationInterface timeDiscretization, int numberOfPaths, double[] initialValues, double riskFreeRate, double[] volatilities, double[][] correlations) {
        this(new BrownianMotion(timeDiscretization, initialValues.length, numberOfPaths, 3141), initialValues, riskFreeRate, volatilities, correlations);
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        return this.initialStates;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        return this.drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        return this.factorLoadingOnPaths[component];
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariableInterface getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1;
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariableInterface getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public RandomVariableInterface getNumeraire(int timeIndex) {
        double time = this.getTime(timeIndex);
        return this.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return this.getRandomVariableForConstant(numeraireValue);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public int getNumberOfComponents() {
        return this.initialValues.length;
    }

    @Override
    public int getNumberOfAssets() {
        return this.getNumberOfComponents();
    }

    public String toString() {
        return "MonteCarloMultiAssetBlackScholesModel [initialValues=" + Arrays.toString(this.initialValues) + ", riskFreeRate=" + this.riskFreeRate + ", volatilities=" + Arrays.toString(this.volatilities) + ", factorLoadings=" + Arrays.toString((Object[])this.factorLoadings) + "]";
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double[] getVolatilities() {
        return this.volatilities;
    }

    @Override
    public int getNumberOfPaths() {
        return this.getProcess().getNumberOfPaths();
    }

    @Override
    public MonteCarloMultiAssetBlackScholesModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        double[] newInitialValues = this.initialValues;
        double newRiskFreeRate = this.riskFreeRate;
        double[] newVolatilities = this.volatilities;
        double[][] newCorrelations = null;
        if (dataModified.containsKey("initialValues")) {
            newInitialValues = (double[])dataModified.get("initialValues");
        }
        if (dataModified.containsKey("riskFreeRate")) {
            newRiskFreeRate = (Double)dataModified.get("riskFreeRate");
        }
        if (dataModified.containsKey("volatilities")) {
            newVolatilities = (double[])dataModified.get("volatilities");
        }
        if (dataModified.containsKey("correlations")) {
            newCorrelations = (double[][])dataModified.get("correlations");
        }
        return new MonteCarloMultiAssetBlackScholesModel(this.getTimeDiscretization(), this.getNumberOfPaths(), newInitialValues, newRiskFreeRate, newVolatilities, newCorrelations);
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int seed) {
        return null;
    }
}

