/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.finmath.exception.CalculationException;
import net.finmath.functions.NormalDistribution;
import net.finmath.functions.PoissonDistribution;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.MertonModel;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloMertonModel
implements AssetModelMonteCarloSimulationInterface {
    private final MertonModel model;
    private final double initialValue;
    private final int seed;

    public MonteCarloMertonModel(TimeDiscretizationInterface timeDiscretization, int numberOfPaths, int seed, double initialValue, double riskFreeRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev) {
        this.initialValue = initialValue;
        this.seed = seed;
        this.model = new MertonModel(initialValue, riskFreeRate, volatility, jumpIntensity, jumpSizeMean, jumpSizeStDev);
        IntFunction<IntFunction> inverseCumulativeDistributionFunctions = i -> j -> {
            if (j == 0) {
                double sqrtOfTimeStep = Math.sqrt(timeDiscretization.getTimeStep(i));
                return x -> NormalDistribution.inverseCumulativeDistribution(x) * sqrtOfTimeStep;
            }
            if (j == 1) {
                return x -> NormalDistribution.inverseCumulativeDistribution(x);
            }
            if (j == 2) {
                double timeStep = timeDiscretization.getTimeStep(i);
                PoissonDistribution poissonDistribution = new PoissonDistribution(jumpIntensity * timeStep);
                return x -> poissonDistribution.inverseCumulativeDistribution(x);
            }
            return null;
        };
        IndependentIncrements icrements = new IndependentIncrements(timeDiscretization, 3, numberOfPaths, seed, inverseCumulativeDistributionFunctions){
            private static final long serialVersionUID = -7858107751226404629L;

            @Override
            public RandomVariableInterface getIncrement(int timeIndex, int factor) {
                if (factor == 1) {
                    RandomVariableInterface Z = super.getIncrement(timeIndex, 1);
                    RandomVariableInterface N = super.getIncrement(timeIndex, 2);
                    return Z.mult(N.sqrt());
                }
                return super.getIncrement(timeIndex, factor);
            }
        };
        ProcessEulerScheme process = new ProcessEulerScheme(icrements);
        process.setModel(this.model);
        this.model.setProcess(process);
    }

    @Override
    public RandomVariableInterface getAssetValue(double time, int assetIndex) throws CalculationException {
        return this.getAssetValue(this.getTimeIndex(time), assetIndex);
    }

    @Override
    public RandomVariableInterface getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.model.getProcess().getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariableInterface getNumeraire(int timeIndex) throws CalculationException {
        double time = this.getTime(timeIndex);
        return this.model.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialTime = dataModified.get("initialTime") != null ? ((Number)dataModified.get("initialTime")).doubleValue() : this.getTime(0);
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue;
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.model.getRiskFreeRate();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.model.getVolatility();
        double newJumpIntensity = dataModified.get("jumpIntensity") != null ? ((Number)dataModified.get("jumpIntensity")).doubleValue() : this.model.getJumpIntensity();
        double newJumpSizeMean = dataModified.get("jumpSizeMean") != null ? ((Number)dataModified.get("jumpSizeMean")).doubleValue() : this.model.getVolatility();
        double newJumpSizeStdDev = dataModified.get("jumpSizeStdDev") != null ? ((Number)dataModified.get("jumpSizeStdDev")).doubleValue() : this.model.getVolatility();
        int newSeed = dataModified.get("seed") != null ? ((Number)dataModified.get("seed")).intValue() : this.seed;
        return new MonteCarloMertonModel(this.model.getProcess().getTimeDiscretization().getTimeShiftedTimeDiscretization(newInitialTime - this.getTime(0)), this.model.getProcess().getNumberOfPaths(), newSeed, newInitialValue, newRiskFreeRate, newVolatility, newJumpIntensity, newJumpSizeMean, newJumpSizeStdDev);
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int seed) {
        HashMap<String, Integer> dataModified = new HashMap<String, Integer>();
        dataModified.put("seed", new Integer(seed));
        return this.getCloneWithModifiedData(dataModified);
    }

    @Override
    public int getNumberOfPaths() {
        return this.model.getProcess().getNumberOfPaths();
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.model.getProcess().getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.model.getProcess().getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.model.getProcess().getTimeIndex(time);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.model.getProcess().getMonteCarloWeights(timeIndex);
    }
}

