/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class MertonModel
extends AbstractModel {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final double jumpIntensity;
    private final double jumpSizeMean;
    private final double jumpSizeStdDev;

    public MertonModel(double initialValue, double riskFreeRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.jumpIntensity = jumpIntensity;
        this.jumpSizeMean = jumpSizeMean;
        this.jumpSizeStdDev = jumpSizeStDev;
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        return new RandomVariableInterface[]{this.getProcess().getStochasticDriver().getRandomVariableForConstant(Math.log(this.initialValue))};
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(Math.exp(this.riskFreeRate * time));
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        return new RandomVariableInterface[]{this.getProcess().getStochasticDriver().getRandomVariableForConstant(this.riskFreeRate - (Math.exp(this.jumpSizeMean) - 1.0) * this.jumpIntensity - 0.5 * this.volatility * this.volatility)};
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factors = new RandomVariableInterface[]{this.getProcess().getStochasticDriver().getRandomVariableForConstant(this.volatility), this.getProcess().getStochasticDriver().getRandomVariableForConstant(this.jumpSizeStdDev), this.getProcess().getStochasticDriver().getRandomVariableForConstant(this.jumpSizeMean - 0.5 * this.jumpSizeStdDev * this.jumpSizeStdDev)};
        return factors;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public AbstractModelInterface getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        return null;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public double getJumpIntensity() {
        return this.jumpIntensity;
    }

    public double getJumpSizeMean() {
        return this.jumpSizeMean;
    }

    public double getJumpSizeStdDev() {
        return this.jumpSizeStdDev;
    }
}

