/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;

public class InhomogeneousDisplacedLognomalModel
extends AbstractModel {
    private final double initialValue;
    private final double riskFreeRate;
    private final double displacement;
    private final double volatility;
    private final boolean isUseMilsteinCorrection;
    private RandomVariableInterface[] initialValueVector = new RandomVariableInterface[1];

    public InhomogeneousDisplacedLognomalModel(double initialValue, double riskFreeRate, double displacement, double volatility, boolean isUseMilsteinCorrection) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.displacement = displacement;
        this.volatility = volatility;
        this.isUseMilsteinCorrection = isUseMilsteinCorrection;
    }

    public InhomogeneousDisplacedLognomalModel(double initialValue, double riskFreeRate, double displacement, double volatility) {
        this(initialValue, riskFreeRate, displacement, volatility, false);
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        if (this.initialValueVector[0] == null) {
            this.initialValueVector[0] = this.getRandomVariableForConstant(this.initialValue);
        }
        return this.initialValueVector;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        double dt = this.getProcess().getTimeDiscretization().getTimeStep(timeIndex);
        RandomVariableInterface[] drift = new RandomVariableInterface[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            drift[componentIndex] = realizationAtTimeIndex[componentIndex].mult((Math.exp(this.riskFreeRate * dt) - 1.0) / dt);
            if (!this.isUseMilsteinCorrection) continue;
            drift[componentIndex] = drift[componentIndex].add(realizationAtTimeIndex[componentIndex].add(this.displacement).mult(0.5 * this.volatility * this.volatility * Math.exp(this.riskFreeRate * dt)).mult(this.getProcess().getStochasticDriver().getIncrement(timeIndex, 0).squared().sub(dt)));
        }
        return drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        double dt = this.getProcess().getTimeDiscretization().getTimeStep(timeIndex);
        RandomVariableInterface[] volatilityOnPaths = new RandomVariableInterface[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            volatilityOnPaths[componentIndex] = realizationAtTimeIndex[componentIndex].add(this.displacement).mult(this.volatility * Math.exp(this.riskFreeRate * dt));
        }
        return volatilityOnPaths;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return this.getRandomVariableForConstant(numeraireValue);
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public InhomogeneousDisplacedLognomalModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue;
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.getRiskFreeRate();
        double newDisplacement = dataModified.get("displacement") != null ? ((Number)dataModified.get("displacement")).doubleValue() : this.getVolatility();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.getVolatility();
        return new InhomogeneousDisplacedLognomalModel(newInitialValue, newRiskFreeRate, newDisplacement, newVolatility, this.isUseMilsteinCorrection);
    }

    public String toString() {
        return super.toString() + "\nBachelierModel:\n  initial value...:" + this.initialValue + "\n  risk free rate..:" + this.riskFreeRate + "\n  volatiliy.......:" + this.volatility;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }
}

