/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;

public class DisplacedLognomalModelExperimental
extends AbstractModel {
    private final double initialValue;
    private final double riskFreeRate;
    private final double displacement;
    private final double volatility;
    private RandomVariableInterface[] initialValueVector = new RandomVariableInterface[1];

    public DisplacedLognomalModelExperimental(double initialValue, double riskFreeRate, double displacement, double volatility) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.displacement = displacement;
        this.volatility = volatility;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        if (this.initialValueVector[0] == null) {
            this.initialValueVector[0] = this.getRandomVariableForConstant(Math.log(this.initialValue + this.displacement));
        }
        return this.initialValueVector;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        RandomVariableInterface[] drift = new RandomVariableInterface[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            drift[componentIndex] = this.getRandomVariableForConstant(this.riskFreeRate - 0.5 * this.volatility * this.volatility - this.riskFreeRate * this.displacement);
        }
        return drift;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface volatilityOnPaths = this.getRandomVariableForConstant(this.volatility);
        return new RandomVariableInterface[]{volatilityOnPaths};
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.exp().sub(this.displacement);
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.add(this.displacement).log();
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return this.getRandomVariableForConstant(numeraireValue);
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public DisplacedLognomalModelExperimental getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue;
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.getRiskFreeRate();
        double newDisplacement = dataModified.get("displacement") != null ? ((Number)dataModified.get("displacement")).doubleValue() : this.getVolatility();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.getVolatility();
        return new DisplacedLognomalModelExperimental(newInitialValue, newRiskFreeRate, newDisplacement, newVolatility);
    }

    public String toString() {
        return super.toString() + "\nBachelierModel:\n  initial value...:" + this.initialValue + "\n  risk free rate..:" + this.riskFreeRate + "\n  volatiliy.......:" + this.volatility;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }
}

