/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import org.apache.commons.math3.util.FastMath;

public class RandomVariableLazyEvaluation
implements RandomVariableInterface {
    private final double time;
    private IntToDoubleFunction realizations;
    private final int size;
    private final double valueIfNonStochastic;
    private transient double[] realizationsArray = null;

    public RandomVariableLazyEvaluation(RandomVariableInterface value) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : value::get;
        this.size = value.size();
        this.valueIfNonStochastic = value.isDeterministic() ? value.get(0) : Double.NaN;
    }

    public RandomVariableLazyEvaluation(double value) {
        this(0.0, value);
    }

    public RandomVariableLazyEvaluation(RandomVariableInterface value, DoubleUnaryOperator function) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : i -> function.applyAsDouble(value.get(i));
        this.size = value.size();
        this.valueIfNonStochastic = value.isDeterministic() ? function.applyAsDouble(value.get(0)) : Double.NaN;
    }

    public RandomVariableLazyEvaluation(double time, double value) {
        this.time = time;
        this.realizations = null;
        this.size = 1;
        this.valueIfNonStochastic = value;
    }

    public RandomVariableLazyEvaluation(double time, int numberOfPath, double value) {
        this.time = time;
        this.size = numberOfPath;
        this.realizations = i -> value;
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariableLazyEvaluation(double time, double[] realisations) {
        this.time = time;
        this.size = realisations.length;
        this.realizations = i -> realisations[i];
        this.valueIfNonStochastic = Double.NaN;
        this.realizationsArray = realisations;
    }

    public RandomVariableLazyEvaluation(double time, IntToDoubleFunction realisations, int size) {
        this.time = time;
        this.realizations = realisations;
        this.size = size;
        this.valueIfNonStochastic = Double.NaN;
    }

    @Override
    public boolean equals(RandomVariableInterface randomVariable) {
        if (this.time != randomVariable.getFiltrationTime()) {
            return false;
        }
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            return this.valueIfNonStochastic == randomVariable.get(0);
        }
        if (this.isDeterministic() != randomVariable.isDeterministic()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == randomVariable.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getFiltrationTime() {
        return this.time;
    }

    @Override
    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        this.cache();
        return this.realizationsArray[pathOrState];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.getRealizationsStream().min().getAsDouble();
    }

    @Override
    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.getRealizationsStream().max().getAsDouble();
    }

    @Override
    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getRealizationsStream().sum() / (double)this.size();
    }

    @Override
    public double getAverage(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.cache().mult(probabilities).getRealizationsStream().sum();
    }

    @Override
    public double getVariance() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double sumOfSquared = 0.0;
        for (double realization : this.getRealizations()) {
            sum += realization;
            sumOfSquared += realization * realization;
        }
        return sumOfSquared / (double)this.size() - sum / (double)this.size() * sum / (double)this.size();
    }

    @Override
    public double getVariance(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double mean = 0.0;
        double secondMoment = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            mean += this.get(i) * probabilities.get(i);
            secondMoment += this.get(i) * this.get(i) * probabilities.get(i);
        }
        return secondMoment - mean * mean;
    }

    @Override
    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    @Override
    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStandardDeviation(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    @Override
    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    @Override
    public double getStandardError(RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / (double)this.size();
    }

    @Override
    public double getQuantile(double quantile) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double[] realizationsSorted = (double[])this.getRealizations().clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * (1.0 - quantile) - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    @Override
    public double getQuantile(double quantile, RandomVariableInterface probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        double[] realizationsSorted = (double[])this.getRealizations().clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            double[] realizationsSorted = (double[])this.getRealizations().clone();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    @Override
    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariableInterface expand(int numberOfPaths) {
        if (this.isDeterministic()) {
            double[] clone = new double[numberOfPaths];
            Arrays.fill(clone, this.valueIfNonStochastic);
            return new RandomVariable(this.time, clone);
        }
        return new RandomVariable(this.time, this.getRealizations());
    }

    @Override
    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.get(0)};
            return result;
        }
        this.cache();
        return this.realizationsArray;
    }

    @Override
    public IntToDoubleFunction getOperator() {
        return this.realizations;
    }

    public RandomVariable getRandomVariable() {
        if (this.isDeterministic()) {
            return new RandomVariable(this.time, this.valueIfNonStochastic);
        }
        return new RandomVariable(this.time, this.getRealizations());
    }

    @Override
    public DoubleStream getRealizationsStream() {
        if (this.isDeterministic()) {
            return DoubleStream.generate(() -> this.valueIfNonStochastic);
        }
        return IntStream.range(0, this.size()).mapToDouble(this.realizations).parallel();
    }

    @Override
    public RandomVariableInterface apply(DoubleUnaryOperator operator) {
        if (this.isDeterministic()) {
            return new RandomVariableLazyEvaluation(this.time, operator.applyAsDouble(this.valueIfNonStochastic));
        }
        IntToDoubleFunction newRealizations = i -> operator.applyAsDouble(this.realizations.applyAsDouble(i));
        return new RandomVariableLazyEvaluation(this.time, newRealizations, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface cache() {
        RandomVariableLazyEvaluation randomVariableLazyEvaluation = this;
        synchronized (randomVariableLazyEvaluation) {
            if (this.realizationsArray == null) {
                this.realizationsArray = this.getRealizationsStream().toArray();
                this.realizations = i -> this.realizationsArray[i];
            }
        }
        return this;
    }

    @Override
    public RandomVariableInterface apply(DoubleBinaryOperator operator, RandomVariableInterface argument) {
        double newTime = Math.max(this.time, argument.getFiltrationTime());
        if (this.isDeterministic() && argument.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, operator.applyAsDouble(this.valueIfNonStochastic, argument.get(0)));
        }
        if (!this.isDeterministic() && argument.isDeterministic()) {
            IntToDoubleFunction newRealizations = i -> operator.applyAsDouble(this.realizations.applyAsDouble(i), argument.get(0));
            return new RandomVariableLazyEvaluation(newTime, newRealizations, this.size());
        }
        if (this.isDeterministic() && !argument.isDeterministic()) {
            double[] argumentRealizations = argument.getRealizations();
            IntToDoubleFunction newRealizations = i -> operator.applyAsDouble(this.valueIfNonStochastic, argumentRealizations[i]);
            return new RandomVariableLazyEvaluation(newTime, newRealizations, argument.size());
        }
        double[] argumentRealizations = argument.getRealizations();
        IntToDoubleFunction newRealizations = i -> operator.applyAsDouble(this.realizations.applyAsDouble(i), argumentRealizations[i]);
        return new RandomVariableLazyEvaluation(newTime, newRealizations, this.size());
    }

    public RandomVariableInterface apply(DoubleBinaryOperator operatorOuter, DoubleBinaryOperator operatorInner, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        IntToDoubleFunction innerResult;
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        if (this.isDeterministic() && argument1.isDeterministic() && argument2.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, operatorOuter.applyAsDouble(this.valueIfNonStochastic, operatorInner.applyAsDouble(argument1.get(0), argument2.get(0))));
        }
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        if (argument1.isDeterministic() && argument2.isDeterministic()) {
            double argument1Realization = argument1.get(0);
            double argument2Realization = argument2.get(0);
            innerResult = i -> operatorInner.applyAsDouble(argument1Realization, argument2Realization);
        } else if (argument1.isDeterministic() && !argument2.isDeterministic()) {
            double argument1Realization = argument1.get(0);
            double[] argument2Realizations = argument2.getRealizations();
            innerResult = i -> operatorInner.applyAsDouble(argument1Realization, argument2Realizations[i]);
        } else if (!argument1.isDeterministic() && argument2.isDeterministic()) {
            double[] argument1Realizations = argument1.getRealizations();
            double argument2Realization = argument2.get(0);
            innerResult = i -> operatorInner.applyAsDouble(argument1Realizations[i], argument2Realization);
        } else {
            double[] argument1Realizations = argument1.getRealizations();
            double[] argument2Realizations = argument2.getRealizations();
            innerResult = i -> operatorInner.applyAsDouble(argument1Realizations[i], argument2Realizations[i]);
        }
        if (this.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, i -> operatorOuter.applyAsDouble(this.valueIfNonStochastic, innerResult.applyAsDouble(i)), newSize);
        }
        return new RandomVariableLazyEvaluation(newTime, i -> operatorOuter.applyAsDouble(this.realizations.applyAsDouble(i), innerResult.applyAsDouble(i)), newSize);
    }

    @Override
    public RandomVariableInterface apply(DoubleTernaryOperator operator, RandomVariableInterface argument1, RandomVariableInterface argument2) {
        IntToDoubleFunction result;
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        if (this.isDeterministic() && argument1.isDeterministic() && argument2.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, operator.applyAsDouble(this.valueIfNonStochastic, argument1.get(0), argument2.get(0)));
        }
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        if (argument1.isDeterministic() && argument2.isDeterministic()) {
            double argument1Realization = argument1.get(0);
            double argument2Realization = argument2.get(0);
            result = this.isDeterministic() ? i -> operator.applyAsDouble(this.valueIfNonStochastic, argument1Realization, argument2Realization) : i -> operator.applyAsDouble(this.realizations.applyAsDouble(i), argument1Realization, argument2Realization);
        } else if (argument1.isDeterministic() && !argument2.isDeterministic()) {
            double argument1Realization = argument1.get(0);
            double[] argument2Realizations = argument2.getRealizations();
            result = this.isDeterministic() ? i -> operator.applyAsDouble(this.valueIfNonStochastic, argument1Realization, argument2Realizations[i]) : i -> operator.applyAsDouble(this.realizations.applyAsDouble(i), argument1Realization, argument2Realizations[i]);
        } else if (!argument1.isDeterministic() && argument2.isDeterministic()) {
            double[] argument1Realizations = argument1.getRealizations();
            double argument2Realization = argument2.get(0);
            result = this.isDeterministic() ? i -> operator.applyAsDouble(this.valueIfNonStochastic, argument1Realizations[i], argument2Realization) : i -> operator.applyAsDouble(this.realizations.applyAsDouble(i), argument1Realizations[i], argument2Realization);
        } else {
            double[] argument1Realizations = argument1.getRealizations();
            double[] argument2Realizations = argument2.getRealizations();
            result = this.isDeterministic() ? i -> operator.applyAsDouble(this.valueIfNonStochastic, argument1Realizations[i], argument2Realizations[i]) : i -> operator.applyAsDouble(this.realizations.applyAsDouble(i), argument1Realizations[i], argument2Realizations[i]);
        }
        return new RandomVariableLazyEvaluation(newTime, result, newSize);
    }

    @Override
    public RandomVariableInterface cap(double cap) {
        return this.apply(x -> Math.min(x, cap));
    }

    @Override
    public RandomVariableInterface floor(double floor) {
        return this.apply(x -> Math.max(x, floor));
    }

    @Override
    public RandomVariableInterface add(double value) {
        return this.apply(x -> x + value);
    }

    @Override
    public RandomVariableInterface sub(double value) {
        return this.apply(x -> x - value);
    }

    @Override
    public RandomVariableInterface mult(double value) {
        return this.apply(x -> x * value);
    }

    @Override
    public RandomVariableInterface div(double value) {
        return this.apply(x -> x / value);
    }

    @Override
    public RandomVariableInterface pow(double exponent) {
        return this.apply(x -> FastMath.pow((double)x, (double)exponent));
    }

    @Override
    public RandomVariableInterface average() {
        return new RandomVariableLazyEvaluation(this.getAverage());
    }

    @Override
    public RandomVariableInterface squared() {
        return this.apply(x -> x * x);
    }

    @Override
    public RandomVariableInterface sqrt() {
        return this.apply(FastMath::sqrt);
    }

    @Override
    public RandomVariableInterface exp() {
        return this.apply(FastMath::exp);
    }

    @Override
    public RandomVariableInterface log() {
        return this.apply(FastMath::log);
    }

    @Override
    public RandomVariableInterface sin() {
        return this.apply(FastMath::sin);
    }

    @Override
    public RandomVariableInterface cos() {
        return this.apply(FastMath::cos);
    }

    @Override
    public RandomVariableInterface add(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x + y, randomVariable);
    }

    @Override
    public RandomVariableInterface sub(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x - y, randomVariable);
    }

    @Override
    public RandomVariableInterface mult(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x * y, randomVariable);
    }

    @Override
    public RandomVariableInterface div(RandomVariableInterface randomVariable) {
        return this.apply((x, y) -> x / y, randomVariable);
    }

    @Override
    public RandomVariableInterface cap(RandomVariableInterface cap) {
        return this.apply(FastMath::min, cap);
    }

    @Override
    public RandomVariableInterface floor(RandomVariableInterface floor) {
        return this.apply(FastMath::max, floor);
    }

    @Override
    public RandomVariableInterface accrue(RandomVariableInterface rate, double periodLength) {
        return this.apply((x, y) -> x * (1.0 + y * periodLength), rate);
    }

    @Override
    public RandomVariableInterface discount(RandomVariableInterface rate, double periodLength) {
        return this.apply((x, y) -> x / (1.0 + y * periodLength), rate);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, RandomVariableInterface valueIfTriggerNegative) {
        return trigger.apply((x, y, z) -> x >= 0.0 ? y : z, valueIfTriggerNonNegative, valueIfTriggerNegative);
    }

    @Override
    public RandomVariableInterface barrier(RandomVariableInterface trigger, RandomVariableInterface valueIfTriggerNonNegative, double valueIfTriggerNegative) {
        return this.barrier(trigger, valueIfTriggerNonNegative, new RandomVariableLazyEvaluation(valueIfTriggerNonNegative.getFiltrationTime(), valueIfTriggerNegative));
    }

    @Override
    public RandomVariableInterface invert() {
        return this.apply(x -> 1.0 / x);
    }

    @Override
    public RandomVariableInterface abs() {
        return this.apply(Math::abs);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, double factor2) {
        return this.apply((x, y) -> x + y * factor2, factor1);
    }

    @Override
    public RandomVariableInterface addProduct(RandomVariableInterface factor1, RandomVariableInterface factor2) {
        return this.apply((x, y) -> x + y, (x, y) -> x * y, factor1, factor2);
    }

    @Override
    public RandomVariableInterface addRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return this.apply((x, y) -> x + y, (x, y) -> x / y, numerator, denominator);
    }

    @Override
    public RandomVariableInterface subRatio(RandomVariableInterface numerator, RandomVariableInterface denominator) {
        return this.apply((x, y) -> x - y, (x, y) -> x / y, numerator, denominator);
    }

    @Override
    public RandomVariableInterface isNaN() {
        if (this.isDeterministic()) {
            return new RandomVariableLazyEvaluation(this.time, Double.isNaN(this.valueIfNonStochastic) ? 1.0 : 0.0);
        }
        double[] newRealizations = new double[this.size()];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Double.isNaN(this.get(i)) ? 1.0 : 0.0;
        }
        return new RandomVariableLazyEvaluation(this.time, newRealizations);
    }

    private /* synthetic */ double lambda$apply$12(DoubleBinaryOperator operatorOuter, DoubleBinaryOperator operatorInner, RandomVariableInterface argument1, RandomVariableInterface argument2, int i) {
        return operatorOuter.applyAsDouble(this.realizations.applyAsDouble(i), operatorInner.applyAsDouble(argument1.get(i), argument2.get(i)));
    }

    private /* synthetic */ double lambda$apply$11(DoubleBinaryOperator operatorOuter, double innerResult, int i) {
        return operatorOuter.applyAsDouble(this.realizations.applyAsDouble(i), innerResult);
    }

    private /* synthetic */ double lambda$apply$9(DoubleBinaryOperator operator, IntToDoubleFunction argumentRealizations, int i) {
        return operator.applyAsDouble(this.realizations.applyAsDouble(i), argumentRealizations.applyAsDouble(i));
    }

    private /* synthetic */ double lambda$apply$7(DoubleBinaryOperator operator, IntToDoubleFunction argumentRealizations, int i) {
        return operator.applyAsDouble(this.valueIfNonStochastic, argumentRealizations.applyAsDouble(i));
    }
}

