/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.RandomVariableLowMemory;
import net.finmath.stochastic.RandomVariableInterface;

public class RandomVariableFactory
extends AbstractRandomVariableFactory {
    final boolean isUseDoublePrecisionFloatingPointImplementation;

    public RandomVariableFactory() {
        this.isUseDoublePrecisionFloatingPointImplementation = true;
    }

    public RandomVariableFactory(boolean isUseDoublePrecisionFloatingPointImplementation) {
        this.isUseDoublePrecisionFloatingPointImplementation = isUseDoublePrecisionFloatingPointImplementation;
    }

    @Override
    public RandomVariableInterface createRandomVariable(double time, double value) {
        if (this.isUseDoublePrecisionFloatingPointImplementation) {
            return new RandomVariable(time, value);
        }
        return new RandomVariableLowMemory(time, value);
    }

    @Override
    public RandomVariableInterface createRandomVariable(double time, double[] values) {
        if (this.isUseDoublePrecisionFloatingPointImplementation) {
            return new RandomVariable(time, values);
        }
        return new RandomVariableLowMemory(time, values);
    }
}

