/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class BrownianMotionView
implements BrownianMotionInterface {
    private BrownianMotionInterface brownianMotion;
    private Integer[] factors;

    public BrownianMotionView(BrownianMotionInterface brownianMotion, Integer[] factors) {
        this.brownianMotion = brownianMotion;
        this.factors = factors;
    }

    @Override
    public RandomVariableInterface getBrownianIncrement(int timeIndex, int factor) {
        return this.brownianMotion.getBrownianIncrement(timeIndex, this.factors[factor]);
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.brownianMotion.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.factors.length;
    }

    @Override
    public int getNumberOfPaths() {
        return this.brownianMotion.getNumberOfPaths();
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.brownianMotion.getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int seed) {
        return new BrownianMotionView(this.brownianMotion.getCloneWithModifiedSeed(seed), this.factors);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface newTimeDiscretization) {
        return new BrownianMotionView(this.brownianMotion.getCloneWithModifiedTimeDiscretization(newTimeDiscretization), this.factors);
    }

    @Override
    public RandomVariableInterface getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }
}

