/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.Serializable;
import net.finmath.functions.NormalDistribution;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.randomnumbers.MersenneTwister;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class BrownianMotion
implements BrownianMotionInterface,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final TimeDiscretizationInterface timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private final AbstractRandomVariableFactory randomVariableFactory;
    private transient RandomVariableInterface[][] brownianIncrements;
    private final Object brownianIncrementsLazyInitLock = new Object();

    public BrownianMotion(TimeDiscretizationInterface timeDiscretization, int numberOfFactors, int numberOfPaths, int seed, AbstractRandomVariableFactory randomVariableFactory) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.randomVariableFactory = randomVariableFactory;
        this.brownianIncrements = null;
    }

    public BrownianMotion(TimeDiscretizationInterface timeDiscretization, int numberOfFactors, int numberOfPaths, int seed) {
        this(timeDiscretization, numberOfFactors, numberOfPaths, seed, new RandomVariableFactory());
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int seed) {
        return new BrownianMotion(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), seed);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface newTimeDiscretization) {
        return new BrownianMotion(newTimeDiscretization, this.getNumberOfFactors(), this.getNumberOfPaths(), this.getSeed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getBrownianIncrement(int timeIndex, int factor) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[timeIndex][factor];
    }

    private void doGenerateBrownianMotion() {
        int timeIndex;
        if (this.brownianIncrements != null) {
            return;
        }
        MersenneTwister mersenneTwister = new MersenneTwister(this.seed);
        double[][][] brownianIncrementsArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors][this.numberOfPaths];
        double[] sqrtOfTimeStep = new double[this.timeDiscretization.getNumberOfTimeSteps()];
        for (timeIndex = 0; timeIndex < sqrtOfTimeStep.length; ++timeIndex) {
            sqrtOfTimeStep[timeIndex] = Math.sqrt(this.timeDiscretization.getTimeStep(timeIndex));
        }
        for (int path = 0; path < this.numberOfPaths; ++path) {
            for (int timeIndex2 = 0; timeIndex2 < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex2) {
                double sqrtDeltaT = sqrtOfTimeStep[timeIndex2];
                for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                    double uniformIncrement = mersenneTwister.nextDouble();
                    brownianIncrementsArray[timeIndex2][factor][path] = NormalDistribution.inverseCumulativeDistribution(uniformIncrement) * sqrtDeltaT;
                }
            }
        }
        this.brownianIncrements = new RandomVariableInterface[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double time = this.timeDiscretization.getTime(timeIndex + 1);
            for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                this.brownianIncrements[timeIndex][factor] = this.randomVariableFactory.createRandomVariable(time, brownianIncrementsArray[timeIndex][factor]);
            }
        }
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return super.toString() + "\ntimeDiscretization: " + this.timeDiscretization.toString() + "\nnumberOfPaths: " + this.numberOfPaths + "\nnumberOfFactors: " + this.numberOfFactors + "\nseed: " + this.seed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrownianMotion that = (BrownianMotion)o;
        if (this.numberOfFactors != that.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != that.numberOfPaths) {
            return false;
        }
        if (this.seed != that.seed) {
            return false;
        }
        return this.timeDiscretization.equals(that.timeDiscretization);
    }

    @Override
    public RandomVariableInterface getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }

    public int hashCode() {
        int result = this.timeDiscretization.hashCode();
        result = 31 * result + this.numberOfFactors;
        result = 31 * result + this.numberOfPaths;
        result = 31 * result + this.seed;
        return result;
    }
}

