/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;

public class Performance
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final AbstractAnalyticProduct productNumerator;
    private final AbstractAnalyticProduct productDenominator;

    public Performance(AbstractAnalyticProduct productNumerator, AbstractAnalyticProduct productDenominator) {
        this.productNumerator = productNumerator;
        this.productDenominator = productDenominator;
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        double valueNumerator = this.productNumerator.getValue(evaluationTime, model);
        double valueDenominator = this.productDenominator.getValue(evaluationTime, model);
        double value = valueNumerator / valueDenominator;
        return value;
    }

    public String toString() {
        return "Performance [productNumerator=" + this.productNumerator + ", productDenominator=" + this.productDenominator + "]";
    }
}

