/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;

public class Cashflow
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final double flowAmount;
    private final double flowDate;
    private final boolean isPayer;
    private final String discountCurveName;

    public Cashflow(String currency, double flowAmount, double flowDate, boolean isPayer, String discountCurveName) {
        this.flowAmount = flowAmount;
        this.flowDate = flowDate;
        this.isPayer = isPayer;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        double discountFactor = this.flowDate > evaluationTime ? discountCurve.getDiscountFactor(model, this.flowDate) : 0.0;
        double value = (this.isPayer ? -1.0 : 1.0) * this.flowAmount * discountFactor;
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }
}

