/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractSwaptionMarketData;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionMarketData
implements AbstractSwaptionMarketData {
    private final ForwardCurveInterface forwardCurve;
    private final DiscountCurveInterface discountCurve;
    private final TimeDiscretizationInterface optionMaturities;
    private final TimeDiscretizationInterface tenor;
    private final double swapPeriodLength;
    private final double[][] impliedVolatilities;

    public SwaptionMarketData(double[] optionMaturities, double[] tenor, double swapPeriodLength, double[][] impliedVolatilities) {
        this.forwardCurve = null;
        this.discountCurve = null;
        this.optionMaturities = new TimeDiscretization(optionMaturities);
        this.tenor = new TimeDiscretization(tenor);
        this.swapPeriodLength = swapPeriodLength;
        this.impliedVolatilities = impliedVolatilities;
    }

    public SwaptionMarketData(ForwardCurveInterface forwardCurve, DiscountCurveInterface discountCurve, double[] optionMaturities, double[] tenor, double swapPeriodLength, double[][] impliedVolatilities) {
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.optionMaturities = new TimeDiscretization(optionMaturities);
        this.tenor = new TimeDiscretization(tenor);
        this.swapPeriodLength = swapPeriodLength;
        this.impliedVolatilities = impliedVolatilities;
    }

    public SwaptionMarketData(ForwardCurveInterface forwardCurve, DiscountCurveInterface discountCurve, TimeDiscretizationInterface optionMatruities, TimeDiscretizationInterface tenor, double swapPeriodLength, double[][] impliedVolatilities) {
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.optionMaturities = optionMatruities;
        this.tenor = tenor;
        this.swapPeriodLength = swapPeriodLength;
        this.impliedVolatilities = impliedVolatilities;
    }

    @Override
    public TimeDiscretizationInterface getOptionMaturities() {
        return this.optionMaturities;
    }

    @Override
    public TimeDiscretizationInterface getTenor() {
        return this.tenor;
    }

    @Override
    public double getSwapPeriodLength() {
        return this.swapPeriodLength;
    }

    @Override
    public double getValue(double optionMatruity, double tenorLength, double periodLength, double strike) {
        throw new RuntimeException("Method not implemented.");
    }

    public double getVolatility(double optionMatruity, double tenorLength) {
        int indexOptionMaturity = this.optionMaturities.getTimeIndex(optionMatruity);
        int indexTenorIndex = this.tenor.getTimeIndex(tenorLength);
        if (indexOptionMaturity < 0) {
            throw new IllegalArgumentException("Option maturity not part of data.");
        }
        if (indexTenorIndex < 0) {
            throw new IllegalArgumentException("Tenor maturity not part of data.");
        }
        return this.impliedVolatilities[indexOptionMaturity][indexTenorIndex];
    }

    @Override
    public double getVolatility(double optionMatruity, double tenorLength, double periodLength, double strike) {
        int indexOptionMaturity = this.optionMaturities.getTimeIndex(optionMatruity);
        int indexTenorIndex = this.tenor.getTimeIndex(tenorLength);
        if (indexOptionMaturity < 0) {
            throw new IllegalArgumentException("Option maturity not part of data.");
        }
        if (indexTenorIndex < 0) {
            throw new IllegalArgumentException("Tenor maturity not part of data.");
        }
        return this.impliedVolatilities[indexOptionMaturity][indexTenorIndex];
    }
}

