/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public class SeasonalCurve
extends AbstractCurve
implements CurveInterface {
    private CurveInterface baseCurve;

    public SeasonalCurve(String name, LocalDate referenceDate, Map<LocalDate, Double> indexFixings, int numberOfYearsToAverage) {
        super(name, referenceDate);
        double[] seasonalAdjustmentCalculated = SeasonalCurve.computeSeasonalAdjustments(referenceDate, indexFixings, numberOfYearsToAverage);
        double[] seasonTimes = new double[12];
        double[] seasonValue = new double[12];
        double seasonValueCummulated = 1.0;
        for (int j = 0; j < 12; ++j) {
            seasonTimes[j] = (double)j / 12.0;
            seasonValue[j] = seasonValueCummulated *= Math.exp(seasonalAdjustmentCalculated[j] / 12.0);
        }
        this.baseCurve = new Curve(name + "-seasonal-base", referenceDate, Curve.InterpolationMethod.PIECEWISE_CONSTANT_LEFTPOINT, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE, seasonTimes, seasonValue);
    }

    public SeasonalCurve(String name, LocalDate referenceDate, CurveInterface baseCurve) {
        super(name, referenceDate);
        this.baseCurve = baseCurve;
    }

    @Override
    public double[] getParameter() {
        return this.baseCurve.getParameter();
    }

    @Override
    public void setParameter(double[] parameter) {
        this.baseCurve.setParameter(parameter);
    }

    @Override
    public double getValue(AnalyticModelInterface model, double time) {
        LocalDate calendar = this.getReferenceDate().plusDays((int)Math.round(time * 365.0));
        int month = calendar.getMonthValue();
        int day = calendar.getDayOfMonth();
        int numberOfDays = calendar.lengthOfMonth();
        double season = (double)(month - 1) / 12.0 + (double)(day - 1) / (double)numberOfDays / 12.0;
        return this.baseCurve.getValue(model, season);
    }

    @Override
    public CurveInterface getCloneForParameter(double[] value) throws CloneNotSupportedException {
        SeasonalCurve newCurve = this.clone();
        newCurve.baseCurve = this.baseCurve.getCloneForParameter(value);
        return newCurve;
    }

    @Override
    public SeasonalCurve clone() throws CloneNotSupportedException {
        return new SeasonalCurve(this.getName(), this.getReferenceDate(), (CurveInterface)this.baseCurve.clone());
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return new CurveBuilder(this);
    }

    public static double[] computeSeasonalAdjustments(LocalDate referenceDate, Map<LocalDate, Double> indexFixings, int numberOfYearsToAverage) {
        DayCountConvention_ACT_365 modelDcc = new DayCountConvention_ACT_365();
        double[] fixingTimes = new double[indexFixings.size()];
        double[] realizedCPIValues = new double[indexFixings.size()];
        int i = 0;
        ArrayList<LocalDate> fixingDates = new ArrayList<LocalDate>(indexFixings.keySet());
        Collections.sort(fixingDates);
        for (LocalDate fixingDate : fixingDates) {
            fixingTimes[i] = modelDcc.getDaycountFraction(referenceDate, fixingDate);
            realizedCPIValues[i] = indexFixings.get(fixingDate);
            ++i;
        }
        LocalDate lastMonth = (LocalDate)fixingDates.get(fixingDates.size() - 1);
        return SeasonalCurve.computeSeasonalAdjustments(realizedCPIValues, lastMonth.getMonthValue(), numberOfYearsToAverage);
    }

    public static double[] computeSeasonalAdjustments(double[] realizedCPIValues, int lastMonth, int numberOfYearsToAverage) {
        int index;
        double[] averageLogReturn = new double[12];
        Arrays.fill(averageLogReturn, 0.0);
        for (int arrayIndex = 0; arrayIndex < 12 * numberOfYearsToAverage; ++arrayIndex) {
            int month = ((lastMonth - 1 - arrayIndex) % 12 + 12) % 12;
            double logReturn = Math.log(realizedCPIValues[realizedCPIValues.length - 1 - arrayIndex] / realizedCPIValues[realizedCPIValues.length - 2 - arrayIndex]);
            int n = month;
            averageLogReturn[n] = averageLogReturn[n] + logReturn / (double)numberOfYearsToAverage;
        }
        double sum = 0.0;
        for (int index2 = 0; index2 < averageLogReturn.length; ++index2) {
            sum += averageLogReturn[index2];
        }
        double averageSeasonal = sum / (double)averageLogReturn.length;
        double[] seasonalAdjustments = new double[averageLogReturn.length];
        for (index = 0; index < seasonalAdjustments.length; ++index) {
            seasonalAdjustments[index] = averageLogReturn[index] - averageSeasonal;
        }
        for (index = 0; index < seasonalAdjustments.length; ++index) {
            seasonalAdjustments[index] = seasonalAdjustments[index] * 12.0;
        }
        return seasonalAdjustments;
    }

    public static class CurveBuilder
    extends Curve.CurveBuilder
    implements CurveBuilderInterface {
        private SeasonalCurve curve = null;

        public CurveBuilder(SeasonalCurve seasonalCurve) throws CloneNotSupportedException {
            super((Curve)seasonalCurve.baseCurve);
            this.curve = seasonalCurve;
        }

        @Override
        public CurveInterface build() throws CloneNotSupportedException {
            SeasonalCurve buildCurve = this.curve.clone();
            buildCurve.baseCurve = super.build();
            this.curve = null;
            return buildCurve;
        }
    }
}

