/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class DiscountCurve
extends Curve
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = -4126228588123963885L;

    private DiscountCurve(String name) {
        super(name, null, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.LOG_OF_VALUE_PER_TIME);
    }

    private DiscountCurve(String name, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        super(name, null, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    private DiscountCurve(String name, LocalDate referenceDate, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        super(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String name, LocalDate referenceDate, double[] times, double[] givenDiscountFactors, boolean[] isParameter, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        DiscountCurve discountFactors = new DiscountCurve(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            discountFactors.addDiscountFactor(times[timeIndex], givenDiscountFactors[timeIndex], isParameter != null && isParameter[timeIndex]);
        }
        return discountFactors;
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors, boolean[] isParameter, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        return DiscountCurve.createDiscountCurveFromDiscountFactors(name, null, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        boolean[] isParameter = new boolean[times.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            isParameter[timeIndex] = times[timeIndex] > 0.0;
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors) {
        DiscountCurve discountFactors = new DiscountCurve(name);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            discountFactors.addDiscountFactor(times[timeIndex], givenDiscountFactors[timeIndex], times[timeIndex] > 0.0);
        }
        return discountFactors;
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenZeroRates, boolean[] isParameter, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.exp(-givenZeroRates[timeIndex] * times[timeIndex]);
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String name, Date referenceDate, double[] times, double[] givenZeroRates, boolean[] isParameter, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        return DiscountCurve.createDiscountCurveFromZeroRates(name, referenceDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), times, givenZeroRates, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    @Deprecated
    public static DiscountCurve createDiscountCurveFromZeroRates(String name, double[] times, double[] givenZeroRates, boolean[] isParameter, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        return DiscountCurve.createDiscountCurveFromZeroRates(name, (LocalDate)null, times, givenZeroRates, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenZeroRates, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenZeroRates.length];
        boolean[] isParameter = new boolean[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.exp(-givenZeroRates[timeIndex] * times[timeIndex]);
            isParameter[timeIndex] = false;
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromZeroRates(String name, double[] times, double[] givenZeroRates) {
        double[] givenDiscountFactors = new double[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.exp(-givenZeroRates[timeIndex] * times[timeIndex]);
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactors);
    }

    public static DiscountCurve createDiscountCurveFromAnnualizedZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenAnnualizedZeroRates, boolean[] isParameter, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenAnnualizedZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.pow(1.0 + givenAnnualizedZeroRates[timeIndex], -times[timeIndex]);
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurve createDiscountCurveFromAnnualizedZeroRates(String name, LocalDate referenceDate, double[] times, double[] givenAnnualizedZeroRates, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity) {
        double[] givenDiscountFactors = new double[givenAnnualizedZeroRates.length];
        boolean[] isParameter = new boolean[givenAnnualizedZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = Math.pow(1.0 + givenAnnualizedZeroRates[timeIndex], -times[timeIndex]);
            isParameter[timeIndex] = false;
        }
        return DiscountCurve.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterface createDiscountFactorsFromForwardRates(String name, TimeDiscretizationInterface tenor, double[] forwardRates) {
        DiscountCurve discountFactors = new DiscountCurve(name);
        double df = 1.0;
        for (int timeIndex = 0; timeIndex < tenor.getNumberOfTimeSteps(); ++timeIndex) {
            discountFactors.addDiscountFactor(tenor.getTime(timeIndex + 1), df /= 1.0 + forwardRates[timeIndex] * tenor.getTimeStep(timeIndex), tenor.getTime(timeIndex + 1) > 0.0);
        }
        return discountFactors;
    }

    @Override
    public double getDiscountFactor(double maturity) {
        return this.getDiscountFactor(null, maturity);
    }

    @Override
    public double getDiscountFactor(AnalyticModelInterface model, double maturity) {
        return this.getValue(model, maturity);
    }

    public double getZeroRate(double maturity) {
        if (maturity == 0.0) {
            return this.getZeroRate(1.0E-14);
        }
        return -Math.log(this.getDiscountFactor(null, maturity)) / maturity;
    }

    public double[] getZeroRates(double[] maturities) {
        double[] values = new double[maturities.length];
        for (int i = 0; i < maturities.length; ++i) {
            values[i] = this.getZeroRate(maturities[i]);
        }
        return values;
    }

    protected void addDiscountFactor(double maturity, double discountFactor, boolean isParameter) {
        this.addPoint(maturity, discountFactor, isParameter);
    }

    @Override
    public String toString() {
        return "DiscountCurve [" + super.toString() + "]";
    }
}

