/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.interpolation.RationalFunctionInterpolation;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.time.FloatingpointDate;

public class Curve
extends AbstractCurve
implements Serializable,
Cloneable {
    private ArrayList<Point> points = new ArrayList();
    private ArrayList<Point> pointsBeingParameters = new ArrayList();
    private InterpolationMethod interpolationMethod = InterpolationMethod.CUBIC_SPLINE;
    private ExtrapolationMethod extrapolationMethod = ExtrapolationMethod.CONSTANT;
    private InterpolationEntity interpolationEntity = InterpolationEntity.LOG_OF_VALUE;
    private RationalFunctionInterpolation rationalFunctionInterpolation = null;
    private final Object rationalFunctionInterpolationLazyInitLock = new Object();
    private SoftReference<Map<Double, Double>> curveCacheReference = null;
    private static final long serialVersionUID = -4126228588123963885L;
    static NumberFormat formatterReal = NumberFormat.getInstance(Locale.US);

    public Curve(String name, LocalDate referenceDate, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod, InterpolationEntity interpolationEntity, double[] times, double[] values) {
        super(name, referenceDate);
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
        if (times.length != values.length) {
            throw new IllegalArgumentException("Length of times not equal to length of values.");
        }
        for (int i = 0; i < times.length; ++i) {
            this.addPoint(times[i], values[i], false);
        }
    }

    protected Curve(String name, LocalDate referenceDate, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod, InterpolationEntity interpolationEntity) {
        super(name, referenceDate);
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
    }

    private Curve(String name, LocalDate referenceDate) {
        super(name, referenceDate);
    }

    @Override
    public double getValue(double time) {
        return this.getValue(null, time);
    }

    @Override
    public double getValue(AnalyticModelInterface model, double time) {
        Double valueFromCache;
        Map<Double, Double> curveCache;
        Map<Double, Double> map = curveCache = this.curveCacheReference != null ? this.curveCacheReference.get() : null;
        if (curveCache == null) {
            curveCache = new ConcurrentHashMap<Double, Double>();
            this.curveCacheReference = new SoftReference<Map<Double, Double>>(curveCache);
        }
        if ((valueFromCache = curveCache.get(time)) != null) {
            return valueFromCache;
        }
        double value = this.valueFromInterpolationEntity(this.getInterpolationEntityValue(time), time);
        curveCache.put(time, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getInterpolationEntityValue(double time) {
        Object object = this.rationalFunctionInterpolationLazyInitLock;
        synchronized (object) {
            if (this.rationalFunctionInterpolation == null) {
                double[] pointsArray = new double[this.points.size()];
                double[] valuesArray = new double[this.points.size()];
                for (int i = 0; i < this.points.size(); ++i) {
                    pointsArray[i] = this.points.get((int)i).time;
                    valuesArray[i] = this.points.get((int)i).value;
                }
                this.rationalFunctionInterpolation = new RationalFunctionInterpolation(pointsArray, valuesArray, RationalFunctionInterpolation.InterpolationMethod.valueOf(this.interpolationMethod.toString()), RationalFunctionInterpolation.ExtrapolationMethod.valueOf(this.extrapolationMethod.toString()));
            }
        }
        return this.rationalFunctionInterpolation.getValue(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPoint(double time, double value, boolean isParameter) {
        Object object = this.rationalFunctionInterpolationLazyInitLock;
        synchronized (object) {
            if (this.interpolationEntity == InterpolationEntity.LOG_OF_VALUE_PER_TIME && time == 0.0) {
                if (value == 1.0 && !isParameter) {
                    return;
                }
                throw new IllegalArgumentException("The interpolation method LOG_OF_VALUE_PER_TIME does not allow to add a value at time = 0 other than 1.0 (received " + value + ").");
            }
            double interpolationEntityValue = this.interpolationEntityFromValue(value, time);
            int index = this.getTimeIndex(time);
            if (index >= 0) {
                if (this.points.get((int)index).value == interpolationEntityValue) {
                    return;
                }
                if (isParameter) {
                    return;
                }
                throw new RuntimeException("Trying to add a value for a time for which another value already exists.");
            }
            Point point = new Point(time, interpolationEntityValue, isParameter);
            this.points.add(-index - 1, point);
            if (isParameter) {
                int parameterIndex = this.getParameterIndex(time);
                if (parameterIndex >= 0) {
                    new RuntimeException("Curve inconsistent.");
                }
                this.pointsBeingParameters.add(-parameterIndex - 1, point);
            }
            this.rationalFunctionInterpolation = null;
            this.curveCacheReference = null;
        }
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public ExtrapolationMethod getExtrapolationMethod() {
        return this.extrapolationMethod;
    }

    public InterpolationEntity getInterpolationEntity() {
        return this.interpolationEntity;
    }

    protected int getTimeIndex(double time) {
        Point point = new Point(time, Double.NaN, false);
        return Collections.binarySearch(this.points, point);
    }

    protected int getParameterIndex(double time) {
        Point point = new Point(time, Double.NaN, false);
        return Collections.binarySearch(this.pointsBeingParameters, point);
    }

    @Override
    public double[] getParameter() {
        double[] parameters = new double[this.pointsBeingParameters.size()];
        for (int i = 0; i < this.pointsBeingParameters.size(); ++i) {
            parameters[i] = this.valueFromInterpolationEntity(this.pointsBeingParameters.get((int)i).value, this.pointsBeingParameters.get((int)i).time);
        }
        return parameters;
    }

    @Override
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException("This class is immutable. Use getCloneForParameter(double[]) instead.");
    }

    private void setParameterPrivate(double[] parameter) {
        for (int i = 0; i < this.pointsBeingParameters.size(); ++i) {
            this.pointsBeingParameters.get((int)i).value = this.interpolationEntityFromValue(parameter[i], this.pointsBeingParameters.get((int)i).time);
        }
        this.rationalFunctionInterpolation = null;
        this.curveCacheReference = null;
    }

    private double interpolationEntityFromValue(double value, double time) {
        switch (this.interpolationEntity) {
            default: {
                return value;
            }
            case LOG_OF_VALUE: {
                return Math.log(Math.max(value, 0.0));
            }
            case LOG_OF_VALUE_PER_TIME: 
        }
        if (time == 0.0) {
            throw new IllegalArgumentException("The interpolation method LOG_OF_VALUE_PER_TIME does not allow to add a value at time = 0.");
        }
        return Math.log(Math.max(value, 0.0)) / time;
    }

    private double valueFromInterpolationEntity(double interpolationEntityValue, double time) {
        switch (this.interpolationEntity) {
            default: {
                return interpolationEntityValue;
            }
            case LOG_OF_VALUE: {
                return Math.exp(interpolationEntityValue);
            }
            case LOG_OF_VALUE_PER_TIME: 
        }
        return Math.exp(interpolationEntityValue * time);
    }

    @Override
    public Curve clone() throws CloneNotSupportedException {
        Curve newCurve = (Curve)super.clone();
        newCurve.points = new ArrayList();
        newCurve.pointsBeingParameters = new ArrayList();
        newCurve.rationalFunctionInterpolation = null;
        newCurve.curveCacheReference = null;
        for (Point point : this.points) {
            Point newPoint = (Point)point.clone();
            newCurve.points.add(newPoint);
            if (!point.isParameter) continue;
            newCurve.pointsBeingParameters.add(newPoint);
        }
        return newCurve;
    }

    @Override
    public CurveInterface getCloneForParameter(double[] parameter) throws CloneNotSupportedException {
        if (Arrays.equals(parameter, this.getParameter())) {
            return this;
        }
        Curve newCurve = this.clone();
        newCurve.setParameterPrivate(parameter);
        return newCurve;
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        CurveBuilder curveBuilder = new CurveBuilder(this);
        return curveBuilder;
    }

    @Override
    public String toString() {
        StringBuilder curveTableString = new StringBuilder();
        DecimalFormat formatTime = new DecimalFormat("0.00000000E0");
        for (Point point : this.points) {
            curveTableString.append(formatTime.format(point.time) + "\t");
            curveTableString.append(FloatingpointDate.getDateFromFloatingPointDate(this.getReferenceDate(), point.time) + "\t");
            curveTableString.append(this.valueFromInterpolationEntity(point.value, point.time) + "\n");
        }
        return "Curve [points=" + this.points + ", pointsBeingParameters=" + this.pointsBeingParameters + ", interpolationMethod=" + (Object)((Object)this.interpolationMethod) + ", extrapolationMethod=" + (Object)((Object)this.extrapolationMethod) + ", interpolationEntity=" + (Object)((Object)this.interpolationEntity) + ", rationalFunctionInterpolation=" + this.rationalFunctionInterpolation + ", toString()=" + super.toString() + ",\n" + curveTableString + "]";
    }

    public static class CurveBuilder
    implements CurveBuilderInterface {
        private Curve curve = null;

        public CurveBuilder() {
            this.curve = new Curve(null, null);
        }

        public CurveBuilder(String name, LocalDate referenceDate) {
            this.curve = new Curve(name, referenceDate);
        }

        public CurveBuilder(Curve curve) throws CloneNotSupportedException {
            this.curve = curve.clone();
        }

        @Override
        public CurveInterface build() throws CloneNotSupportedException {
            Curve buildCurve = this.curve;
            this.curve = null;
            return buildCurve;
        }

        public CurveBuilderInterface setInterpolationMethod(InterpolationMethod interpolationMethod) {
            this.curve.interpolationMethod = interpolationMethod;
            return this;
        }

        public CurveBuilderInterface setExtrapolationMethod(ExtrapolationMethod extrapolationMethod) {
            this.curve.extrapolationMethod = extrapolationMethod;
            return this;
        }

        public CurveBuilderInterface setInterpolationEntity(InterpolationEntity interpolationEntity) {
            this.curve.interpolationEntity = interpolationEntity;
            return this;
        }

        @Override
        public CurveBuilderInterface addPoint(double time, double value, boolean isParameter) {
            this.curve.addPoint(time, value, isParameter);
            return this;
        }
    }

    private static class Point
    implements Comparable<Point>,
    Serializable {
        private static final long serialVersionUID = 8857387999991917430L;
        public double time;
        public double value;
        public boolean isParameter;

        public Point(double time, double value, boolean isParameter) {
            this.time = time;
            this.value = value;
            this.isParameter = isParameter;
        }

        @Override
        public int compareTo(Point point) {
            if (this.time < point.time) {
                return -1;
            }
            if (this.time > point.time) {
                return 1;
            }
            return 0;
        }

        public Object clone() {
            return new Point(this.time, this.value, this.isParameter);
        }
    }

    public static enum InterpolationEntity {
        VALUE,
        LOG_OF_VALUE,
        LOG_OF_VALUE_PER_TIME;

    }

    public static enum ExtrapolationMethod {
        DEFAULT,
        CONSTANT,
        LINEAR;

    }

    public static enum InterpolationMethod {
        PIECEWISE_CONSTANT,
        PIECEWISE_CONSTANT_LEFTPOINT,
        PIECEWISE_CONSTANT_RIGHTPOINT,
        LINEAR,
        CUBIC_SPLINE,
        AKIMA,
        AKIMA_CONTINUOUS,
        HARMONIC_SPLINE,
        HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING;

    }
}

