/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;

public class AnalyticModel
implements AnalyticModelInterface,
Cloneable {
    private final Map<String, CurveInterface> curvesMap = new HashMap<String, CurveInterface>();
    private final Map<String, VolatilitySurfaceInterface> volatilitySurfaceMap = new HashMap<String, VolatilitySurfaceInterface>();

    public AnalyticModel() {
    }

    public AnalyticModel(CurveInterface[] curves) {
        for (CurveInterface curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
        }
    }

    public AnalyticModel(Collection<CurveInterface> curves) {
        for (CurveInterface curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
        }
    }

    @Override
    public CurveInterface getCurve(String name) {
        return this.curvesMap.get(name);
    }

    @Override
    public AnalyticModelInterface addCurve(String name, CurveInterface curve) {
        AnalyticModel newModel = this.clone();
        newModel.curvesMap.put(name, curve);
        return newModel;
    }

    public AnalyticModelInterface addCurve(CurveInterface curve) {
        AnalyticModel newModel = this.clone();
        newModel.curvesMap.put(curve.getName(), curve);
        return newModel;
    }

    @Override
    public AnalyticModelInterface addCurves(CurveInterface ... curves) {
        AnalyticModel newModel = this.clone();
        for (CurveInterface curve : curves) {
            newModel.curvesMap.put(curve.getName(), curve);
        }
        return newModel;
    }

    @Override
    public AnalyticModelInterface addCurves(Set<CurveInterface> curves) {
        AnalyticModel newModel = this.clone();
        for (CurveInterface curve : curves) {
            newModel.curvesMap.put(curve.getName(), curve);
        }
        return newModel;
    }

    @Override
    @Deprecated
    public void setCurve(CurveInterface curve) {
        this.curvesMap.put(curve.getName(), curve);
    }

    @Deprecated
    public void setCurves(CurveInterface[] curves) {
        for (CurveInterface curve : curves) {
            this.setCurve(curve);
        }
    }

    @Override
    public DiscountCurveInterface getDiscountCurve(String discountCurveName) {
        DiscountCurveInterface discountCurve = null;
        CurveInterface curve = this.getCurve(discountCurveName);
        if (DiscountCurveInterface.class.isInstance(curve)) {
            discountCurve = (DiscountCurveInterface)curve;
        }
        return discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardCurve(String forwardCurveName) {
        ForwardCurveInterface forwardCurve = null;
        CurveInterface curve = this.getCurve(forwardCurveName);
        if (ForwardCurveInterface.class.isInstance(curve)) {
            forwardCurve = (ForwardCurveInterface)curve;
        }
        return forwardCurve;
    }

    @Override
    public VolatilitySurfaceInterface getVolatilitySurface(String name) {
        return this.volatilitySurfaceMap.get(name);
    }

    public AnalyticModelInterface addVolatilitySurface(VolatilitySurfaceInterface volatilitySurface) {
        AnalyticModel newModel = this.clone();
        newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
        return newModel;
    }

    @Override
    public AnalyticModelInterface addVolatilitySurfaces(VolatilitySurfaceInterface ... volatilitySurfaces) {
        AnalyticModel newModel = this.clone();
        for (VolatilitySurfaceInterface volatilitySurface : volatilitySurfaces) {
            newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
        }
        return newModel;
    }

    @Override
    public AnalyticModelInterface addVolatilitySurfaces(Set<AbstractVolatilitySurface> volatilitySurfaces) {
        AnalyticModel newModel = this.clone();
        for (VolatilitySurfaceInterface volatilitySurfaceInterface : volatilitySurfaces) {
            newModel.volatilitySurfaceMap.put(volatilitySurfaceInterface.getName(), volatilitySurfaceInterface);
        }
        return newModel;
    }

    @Override
    @Deprecated
    public void setVolatilitySurface(VolatilitySurfaceInterface volatilitySurface) {
        this.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
    }

    private void set(Object marketDataObject) {
        if (marketDataObject instanceof CurveInterface) {
            this.setCurve((CurveInterface)marketDataObject);
        } else if (marketDataObject instanceof VolatilitySurfaceInterface) {
            this.setVolatilitySurface((VolatilitySurfaceInterface)marketDataObject);
        } else {
            throw new IllegalArgumentException("Provided object is not of supported type.");
        }
    }

    @Override
    public AnalyticModel clone() {
        AnalyticModel newModel = new AnalyticModel();
        newModel.curvesMap.putAll(this.curvesMap);
        newModel.volatilitySurfaceMap.putAll(this.volatilitySurfaceMap);
        return newModel;
    }

    @Override
    public AnalyticModelInterface getCloneForParameter(Map<ParameterObjectInterface, double[]> curveParameterPairs) throws CloneNotSupportedException {
        AnalyticModel modelClone = this.clone();
        if (curveParameterPairs != null) {
            for (Map.Entry<ParameterObjectInterface, double[]> curveParameterPair : curveParameterPairs.entrySet()) {
                ParameterObjectInterface newCurve = curveParameterPair.getKey().getCloneForParameter(curveParameterPair.getValue());
                modelClone.set(newCurve);
            }
        }
        return modelClone;
    }

    public String toString() {
        return "AnalyticModel: curves=" + this.curvesMap.keySet() + ", volatilitySurfaces=" + this.volatilitySurfaceMap.keySet();
    }
}

