/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.calibration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.model.curves.CurveInterface;

public class ParameterAggregation<E extends ParameterObjectInterface>
implements ParameterObjectInterface {
    private final Set<ParameterObjectInterface> parameters;

    public ParameterAggregation() {
        this.parameters = new LinkedHashSet<ParameterObjectInterface>();
    }

    public ParameterAggregation(Set<E> parameters) {
        this.parameters = new LinkedHashSet<ParameterObjectInterface>(parameters);
    }

    public ParameterAggregation(E[] parameters) {
        this.parameters = new LinkedHashSet<ParameterObjectInterface>(Arrays.asList(parameters));
    }

    public void add(E parameterObject) {
        this.parameters.add((ParameterObjectInterface)parameterObject);
    }

    public void remove(E parameterObject) {
        this.parameters.remove(parameterObject);
    }

    @Override
    public double[] getParameter() {
        int parameterArraySize = 0;
        for (ParameterObjectInterface parameterVector : this.parameters) {
            if (parameterVector.getParameter() == null) continue;
            parameterArraySize += parameterVector.getParameter().length;
        }
        double[] parameterArray = new double[parameterArraySize];
        int parameterIndex = 0;
        for (ParameterObjectInterface parameterVector : this.parameters) {
            double[] parameterVectorOfDouble = parameterVector.getParameter();
            if (parameterVectorOfDouble == null) continue;
            System.arraycopy(parameterVectorOfDouble, 0, parameterArray, parameterIndex, parameterVectorOfDouble.length);
            parameterIndex += parameterVectorOfDouble.length;
        }
        return parameterArray;
    }

    @Override
    public void setParameter(double[] parameter) {
        int parameterIndex = 0;
        for (ParameterObjectInterface parametrizedObject : this.parameters) {
            double[] parameterVectorOfDouble = parametrizedObject.getParameter();
            if (parameterVectorOfDouble == null) continue;
            System.arraycopy(parameter, parameterIndex, parameterVectorOfDouble, 0, parameterVectorOfDouble.length);
            parameterIndex += parameterVectorOfDouble.length;
            parametrizedObject.setParameter(parameterVectorOfDouble);
        }
    }

    public Map<E, double[]> getObjectsToModifyForParameter(double[] parameter) {
        HashMap<ParameterObjectInterface, double[]> result = new HashMap<ParameterObjectInterface, double[]>();
        int parameterIndex = 0;
        for (ParameterObjectInterface parametrizedObject : this.parameters) {
            double[] parameterVectorOfDouble = (double[])parametrizedObject.getParameter().clone();
            if (parameterVectorOfDouble == null) continue;
            System.arraycopy(parameter, parameterIndex, parameterVectorOfDouble, 0, parameterVectorOfDouble.length);
            parameterIndex += parameterVectorOfDouble.length;
            result.put(parametrizedObject, parameterVectorOfDouble);
        }
        return result;
    }

    @Override
    public CurveInterface getCloneForParameter(double[] value) throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Method getCloneForParameter not supported on an aggregate.");
    }
}

