/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import org.jblas.Solve;

public class LinearAlgebra {
    private static boolean isEigenvalueDecompositionViaSVD = Boolean.parseBoolean(System.getProperty("net.finmath.functions.LinearAlgebra.isEigenvalueDecompositionViaSVD", "false"));
    private static boolean isSolverUseApacheCommonsMath;

    public static double[] solveLinearEquation(double[][] A, double[] b) {
        if (isSolverUseApacheCommonsMath) {
            Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(A);
            DecompositionSolver solver = matrix.getColumnDimension() == matrix.getRowDimension() ? new LUDecomposition((RealMatrix)matrix).getSolver() : new QRDecomposition((RealMatrix)new Array2DRowRealMatrix(A)).getSolver();
            return solver.solve((RealMatrix)new Array2DRowRealMatrix(b)).getColumn(0);
        }
        return Solve.solve((DoubleMatrix)new DoubleMatrix((double[][])A), (DoubleMatrix)new DoubleMatrix((double[])b)).data;
    }

    public static double[][] invert(double[][] matrix) {
        if (isSolverUseApacheCommonsMath) {
            LUDecomposition lu = new LUDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix));
            double[][] matrixInverse = lu.getSolver().getInverse().getData();
            return matrixInverse;
        }
        return Solve.pinv((DoubleMatrix)new DoubleMatrix(matrix)).toArray2();
    }

    public static double[] solveLinearEquationSymmetric(double[][] matrix, double[] vector) {
        if (isSolverUseApacheCommonsMath) {
            DecompositionSolver solver = new LUDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix)).getSolver();
            return solver.solve((RealMatrix)new Array2DRowRealMatrix(vector)).getColumn(0);
        }
        return Solve.solveSymmetric((DoubleMatrix)new DoubleMatrix((double[][])matrix), (DoubleMatrix)new DoubleMatrix((double[])vector)).data;
    }

    public static double[] solveLinearEquationLeastSquare(double[][] matrix, double[] vector) {
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(matrix, false)).getSolver();
        return solver.solve((RealVector)new ArrayRealVector(vector)).toArray();
    }

    public static double[][] getFactorMatrix(double[][] correlationMatrix, int numberOfFactors) {
        return LinearAlgebra.getFactorMatrixUsingCommonsMath(correlationMatrix, numberOfFactors);
    }

    public static double[][] factorReduction(double[][] correlationMatrix, int numberOfFactors) {
        return LinearAlgebra.factorReductionUsingCommonsMath(correlationMatrix, numberOfFactors);
    }

    private static double[][] getFactorMatrixUsingCommonsMath(double[][] correlationMatrix, int numberOfFactors) {
        double[][] eigenVectorMatrix;
        double[] eigenValues;
        if (isEigenvalueDecompositionViaSVD) {
            SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(correlationMatrix));
            eigenValues = svd.getSingularValues();
            eigenVectorMatrix = svd.getV().getData();
        } else {
            EigenDecomposition eigenDecomp = new EigenDecomposition((RealMatrix)new Array2DRowRealMatrix(correlationMatrix, false));
            eigenValues = eigenDecomp.getRealEigenvalues();
            eigenVectorMatrix = eigenDecomp.getV().getData();
        }
        class EigenValueIndex
        implements Comparable<EigenValueIndex> {
            private int index;
            Double value;

            public EigenValueIndex(int index, double value) {
                this.index = index;
                this.value = value;
            }

            @Override
            public int compareTo(EigenValueIndex o) {
                return o.value.compareTo(this.value);
            }
        }
        ArrayList<EigenValueIndex> eigenValueIndices = new ArrayList<EigenValueIndex>();
        for (int i = 0; i < eigenValues.length; ++i) {
            eigenValueIndices.add(i, new EigenValueIndex(i, eigenValues[i]));
        }
        Collections.sort(eigenValueIndices);
        double[][] factorMatrix = new double[eigenValues.length][numberOfFactors];
        for (int factor = 0; factor < numberOfFactors; ++factor) {
            int row;
            int eigenVectorIndex = ((EigenValueIndex)eigenValueIndices.get(factor)).index;
            double eigenValue = eigenValues[eigenVectorIndex];
            double signChange = eigenVectorMatrix[0][eigenVectorIndex] > 0.0 ? 1.0 : -1.0;
            double eigenVectorNormSquared = 0.0;
            for (row = 0; row < eigenValues.length; ++row) {
                eigenVectorNormSquared += eigenVectorMatrix[row][eigenVectorIndex] * eigenVectorMatrix[row][eigenVectorIndex];
            }
            eigenValue = Math.max(eigenValue, 0.0);
            for (row = 0; row < eigenValues.length; ++row) {
                factorMatrix[row][factor] = signChange * Math.sqrt(eigenValue / eigenVectorNormSquared) * eigenVectorMatrix[row][eigenVectorIndex];
            }
        }
        return factorMatrix;
    }

    public static double[][] factorReductionUsingCommonsMath(double[][] correlationMatrix, int numberOfFactors) {
        double[][] factorMatrix = LinearAlgebra.getFactorMatrix(correlationMatrix, numberOfFactors);
        for (int row = 0; row < correlationMatrix.length; ++row) {
            int factor;
            double sumSquared = 0.0;
            for (factor = 0; factor < numberOfFactors; ++factor) {
                sumSquared += factorMatrix[row][factor] * factorMatrix[row][factor];
            }
            if (sumSquared != 0.0) {
                for (factor = 0; factor < numberOfFactors; ++factor) {
                    factorMatrix[row][factor] = factorMatrix[row][factor] / Math.sqrt(sumSquared);
                }
                continue;
            }
            for (factor = 0; factor < numberOfFactors; ++factor) {
                factorMatrix[row][factor] = 1.0;
            }
        }
        double[][] reducedCorrelationMatrix = new Array2DRowRealMatrix(factorMatrix).multiply(new Array2DRowRealMatrix(factorMatrix).transpose()).getData();
        return LinearAlgebra.getFactorMatrix(reducedCorrelationMatrix, numberOfFactors);
    }

    public double[][] exp(double[][] matrix) {
        return MatrixFunctions.expm((DoubleMatrix)new DoubleMatrix(matrix)).toArray2();
    }

    public RealMatrix exp(RealMatrix matrix) {
        return new Array2DRowRealMatrix(this.exp(matrix.getData()));
    }

    static {
        boolean isSolverUseApacheCommonsMath = Boolean.parseBoolean(System.getProperty("net.finmath.functions.LinearAlgebra.isUseApacheCommonsMath", "true"));
        if (!isSolverUseApacheCommonsMath) {
            try {
                double[] x = Solve.solve((DoubleMatrix)new DoubleMatrix((int)2, (int)2, (double[])new double[]{1.0, 1.0, 0.0, 1.0}), (DoubleMatrix)new DoubleMatrix((int)2, (int)1, (double[])new double[]{1.0, 1.0})).data;
                if (x[0] != 1.0 || x[1] != 0.0) {
                    isSolverUseApacheCommonsMath = true;
                }
            }
            catch (UnsatisfiedLinkError e) {
                isSolverUseApacheCommonsMath = true;
            }
        }
        LinearAlgebra.isSolverUseApacheCommonsMath = isSolverUseApacheCommonsMath;
    }
}

