/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products;

import java.util.function.DoubleUnaryOperator;
import net.finmath.exception.CalculationException;
import net.finmath.fouriermethod.CharacteristicFunctionInterface;
import net.finmath.fouriermethod.models.ProcessCharacteristicFunctionInterface;
import net.finmath.integration.SimpsonRealIntegrator;
import org.apache.commons.math3.complex.Complex;

public abstract class AbstractProductFourierTransform
implements CharacteristicFunctionInterface {
    public double getValue(ProcessCharacteristicFunctionInterface model) throws CalculationException {
        CharacteristicFunctionInterface modelCF = model.apply(this.getMaturity());
        double lineOfIntegration = 0.5 * this.getIntegrationDomainImagUpperBound() + this.getIntegrationDomainImagLowerBound();
        DoubleUnaryOperator integrand = real -> {
            Complex z = new Complex(real, lineOfIntegration);
            return ((Complex)modelCF.apply(z.negate())).multiply((Complex)this.apply(z)).getReal();
        };
        SimpsonRealIntegrator integrator = new SimpsonRealIntegrator(-100.0, 100.0, 20000, true);
        return integrator.integrate(integrand) / 2.0 / Math.PI;
    }

    public abstract double getMaturity();

    public abstract double getIntegrationDomainImagLowerBound();

    public abstract double getIntegrationDomainImagUpperBound();
}

