/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.connector.impl;

import javax.servlet.ServletContext;
import net.fckeditor.connector.impl.AbstractLocalFileSystemConnector;
import net.fckeditor.handlers.PropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextConnector
extends AbstractLocalFileSystemConnector {
    private final Logger logger = LoggerFactory.getLogger((Class)ContextConnector.class);

    public void init(ServletContext servletContext) throws Exception {
        this.servletContext = servletContext;
        String defaultAbsolutePath = this.getRealUserFilesAbsolutePath(PropertiesLoader.getUserFilesPath());
        if (defaultAbsolutePath == null) {
            this.logger.error("The context root cannot be resolved against the local filesystem");
            this.logger.info("Your servlet container/application server does not expand deployed war files");
            this.logger.debug("Use another Connector implementation (e.g. LocalConnector) and consult http://www.fckeditor.net/forums/viewtopic.php?f=6&t=11568");
            throw new NullPointerException("The real context root cannot be resolved against the local filesystem");
        }
    }

    protected String getRealUserFilesAbsolutePath(String userFilesAbsolutePath) {
        return this.servletContext.getRealPath(userFilesAbsolutePath);
    }
}

