/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.connector;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.fckeditor.connector.Dispatcher;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.response.GetResponse;
import net.fckeditor.response.UploadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorServlet
extends HttpServlet {
    private static final long serialVersionUID = -5742008970929377161L;
    private final Logger logger = LoggerFactory.getLogger((Class)ConnectorServlet.class);
    private transient Dispatcher dispatcher;

    public void init() throws ServletException {
        try {
            this.dispatcher = new Dispatcher(this.getServletContext());
        }
        catch (Exception e) {
            this.logger.error("Dispatcher could not be initialized", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        GetResponse getResponse = null;
        try {
            ThreadLocalData.beginRequest(request);
            getResponse = this.dispatcher.doGet(request);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            ThreadLocalData.endRequest();
        }
        out.print(getResponse);
        out.flush();
        out.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        UploadResponse uploadResponse = null;
        try {
            ThreadLocalData.beginRequest(request);
            uploadResponse = this.dispatcher.doPost(request);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            ThreadLocalData.endRequest();
        }
        out.print(uploadResponse);
        out.flush();
        out.close();
    }
}

