/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools.generators;

import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Yield;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YieldThread<U, V>
extends Thread {
    private V nextValue;
    private U nextInput;
    boolean itsGeneratorTurn = true;
    private Object monitor = new Object();
    private boolean running = true;
    private boolean started = false;
    private WeakReference<Object> generatorReference;
    private Yield<U, V> generable;

    public YieldThread(Object generator, Yield<U, V> generable) {
        super("yield-thread");
        this.generatorReference = new WeakReference<Object>(generator);
        this.generable = generable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.started = true;
            this.generable.generate();
        }
        finally {
            Object object = this.monitor;
            synchronized (object) {
                this.running = false;
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V next(U nextInput) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.running) {
                throw new NoSuchElementException();
            }
            this.nextInput = nextInput;
            this.itsGeneratorTurn = true;
            if (!this.started) {
                this.start();
                this.started = true;
            }
            this.monitor.notify();
            this.waitForGenerator();
            return this.nextValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public U yield(V nextValue) {
        Object object = this.monitor;
        synchronized (object) {
            this.nextValue = nextValue;
            this.monitor.notify();
            this.itsGeneratorTurn = false;
            this.waitForNext();
            return this.nextInput;
        }
    }

    private void waitForNext() throws ThreadDeath {
        while (this.running && !this.itsGeneratorTurn && this.generatorReference.get() != null) {
            try {
                this.monitor.wait(100L);
            }
            catch (InterruptedException e) {
                throw new ThreadDeath();
            }
        }
        if (!this.running || this.generatorReference.get() == null) {
            throw new ThreadDeath();
        }
    }

    private void waitForGenerator() {
        while (this.running && this.itsGeneratorTurn) {
            try {
                this.monitor.wait(1000L);
            }
            catch (InterruptedException e) {
                this.running = false;
                this.monitor.notifyAll();
            }
        }
        if (!this.running) {
            throw new NoSuchElementException();
        }
    }
}

