/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools;

import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Couple;
import net.ericaro.neoitertools.Index;
import net.ericaro.neoitertools.Mapper;
import net.ericaro.neoitertools.Operator;
import net.ericaro.neoitertools.Predicate;
import net.ericaro.neoitertools.primitives.BooleanIterator;
import net.ericaro.neoitertools.primitives.ByteIterator;
import net.ericaro.neoitertools.primitives.CharacterIterator;
import net.ericaro.neoitertools.primitives.DoubleIterator;
import net.ericaro.neoitertools.primitives.FloatIterator;
import net.ericaro.neoitertools.primitives.IntegerIterator;
import net.ericaro.neoitertools.primitives.LongIterator;
import net.ericaro.neoitertools.primitives.ShortIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterators {
    public static <T> boolean all(Iterator<T> iterator, Predicate<T> predicate) {
        while (iterator.hasNext()) {
            if (((Boolean)predicate.map(iterator.next())).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean any(Iterator<T> iterator, Predicate<T> predicate) {
        while (iterator.hasNext()) {
            if (!((Boolean)predicate.map(iterator.next())).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        LinkedList<T> list = new LinkedList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static String asString(Iterator<Character> chars) {
        return Iterators.asStringBuilder(chars).toString();
    }

    public static StringBuilder asStringBuilder(Iterator<Character> chars) {
        StringBuilder sb = new StringBuilder();
        while (chars.hasNext()) {
            sb.append(chars.next().charValue());
        }
        return sb;
    }

    public static <T> Iterator<T> chain(final Iterator<Iterator<T>> iterators) {
        return new Iterator<T>(){
            Iterator<Iterator<T>> metaIterator;
            Iterator<T> currentIterator;
            Iterator<T> previousIterator;
            {
                this.metaIterator = iterators;
            }

            @Override
            public boolean hasNext() {
                this.move();
                return this.currentIterator.hasNext();
            }

            public void move() {
                if (this.currentIterator == null) {
                    this.currentIterator = this.metaIterator.next();
                }
                while (!this.currentIterator.hasNext() && this.metaIterator.hasNext()) {
                    this.currentIterator = this.metaIterator.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T next() {
                try {
                    this.move();
                    Object t = this.currentIterator.next();
                    return t;
                }
                finally {
                    this.previousIterator = this.currentIterator;
                    this.move();
                }
            }

            @Override
            public void remove() {
                this.previousIterator.remove();
            }
        };
    }

    public static <T> Iterator<T> chain(Iterator<T> i1, Iterator<T> i2) {
        LinkedList<Iterator<T>> list = new LinkedList<Iterator<T>>();
        list.add(i1);
        list.add(i2);
        return Iterators.chain(list.iterator());
    }

    public static Iterator<Integer> count() {
        return Iterators.count(0);
    }

    public static Iterator<Integer> count(final int n) {
        return new Iterator<Integer>(){
            int i;
            {
                this.i = n;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Integer next() {
                return this.i++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> dropwhile(Iterator<T> iterator, Predicate<T> predicate) {
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (((Boolean)predicate.map(t)).booleanValue()) continue;
            return Iterators.chain(new SingletonIterator<T>(t), iterator);
        }
        return new EmptyIterator();
    }

    public static <T> Iterator<Index<T>> enumerate(final Iterator<T> iterator) {
        return new Iterator<Index<T>>(){
            Iterator<Integer> i1 = Iterators.count();

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Index<T> next() {
                return new Index(this.i1.next(), iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> filter(final Predicate<T> predicate, final Iterator<T> iterator) {
        return new Iterator<T>(){
            T next;
            boolean hasNext = false;
            boolean first = true;

            @Override
            public boolean hasNext() {
                if (this.first) {
                    this.first = false;
                    this.move();
                }
                return this.hasNext;
            }

            private void move() {
                this.hasNext = false;
                while (iterator.hasNext()) {
                    this.next = iterator.next();
                    if (!((Boolean)predicate.map(this.next)).booleanValue()) continue;
                    this.hasNext = true;
                    break;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T next() {
                if (this.first) {
                    this.first = false;
                    this.move();
                }
                try {
                    Object t = this.next;
                    return t;
                }
                finally {
                    this.move();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> filterfalse(final Predicate<T> predicate, Iterator<T> iterator) {
        return Iterators.filter(new Predicate<T>(){

            @Override
            public Boolean map(T arg) {
                return (Boolean)predicate.map(arg) == false;
            }
        }, iterator);
    }

    public static Iterator<Character> iter(final CharSequence seq) {
        return new Iterator<Character>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < seq.length();
            }

            @Override
            public Character next() {
                return Character.valueOf(seq.charAt(this.i++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> iter(Iterable<T> iterable) {
        return iterable.iterator();
    }

    public static Iterator<Byte> iter(byte[] array) {
        return new ByteIterator(array);
    }

    public static Iterator<Character> iter(char[] array) {
        return new CharacterIterator(array);
    }

    public static Iterator<Short> iter(short[] array) {
        return new ShortIterator(array);
    }

    public static Iterator<Integer> iter(int[] array) {
        return new IntegerIterator(array);
    }

    public static Iterator<Long> iter(long[] array) {
        return new LongIterator(array);
    }

    public static Iterator<Float> iter(float[] array) {
        return new FloatIterator(array);
    }

    public static Iterator<Double> iter(double[] array) {
        return new DoubleIterator(array);
    }

    public static Iterator<Boolean> iter(boolean[] array) {
        return new BooleanIterator(array);
    }

    public static <T> Iterator<T> iter(final T[] t) {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < t.length;
            }

            @Override
            public T next() {
                return t[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> List<T> list(Iterator<T> iterator) {
        LinkedList<T> list = new LinkedList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <I, O> Iterator<O> map(final Mapper<I, O> mapper, final Iterator<I> iterator) {
        return new Iterator<O>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public O next() {
                return mapper.map(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static Iterator<Integer> range(int end) {
        return Iterators.range(0, end, 1);
    }

    public static Iterator<Integer> range(int start, int end) {
        return Iterators.range(start, end, 1);
    }

    public static Iterator<Integer> range(final int start, final int end, final int step) throws InvalidParameterException {
        if (step == 0) {
            throw new InvalidParameterException("step must be != 0");
        }
        return new Iterator<Integer>(){
            int i;
            {
                this.i = start;
            }

            @Override
            public boolean hasNext() {
                return step > 0 ? this.i < end : this.i > end;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer next() {
                try {
                    Integer n = this.i;
                    return n;
                }
                finally {
                    this.i += step;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> T reduce(Operator<T> operator, Iterator<T> iterator) {
        return Iterators.reduce(operator, iterator, null);
    }

    public static <T> T reduce(Operator<T> operator, Iterator<T> iterator, T initializer) {
        if (!iterator.hasNext()) {
            return initializer;
        }
        if (initializer == null) {
            initializer = iterator.next();
        }
        while (iterator.hasNext()) {
            initializer = operator.operate(initializer, iterator.next());
        }
        return initializer;
    }

    public static <T> Iterator<T> slice(Iterator<T> iterator, int stop) {
        return Iterators.slice_0(iterator, stop, 1);
    }

    public static <T> Iterator<T> slice(Iterator<T> iterator, int start, int stop) {
        return Iterators.slice(iterator, start, stop, 1);
    }

    public static <T> Iterator<T> slice(Iterator<T> iterator, int start, int stop, int step) {
        int i = 0;
        while (i < start && iterator.hasNext()) {
            iterator.next();
        }
        if (i < start) {
            return new EmptyIterator();
        }
        return Iterators.slice_0(iterator, stop - start, step);
    }

    private static <T> Iterator<T> slice_0(final Iterator<T> iterator, final int stop, final int step) {
        if (!iterator.hasNext()) {
            return new EmptyIterator();
        }
        return new Iterator<T>(){
            int i = 0;
            boolean hasNext = false;
            T next = iterator.next();

            @Override
            public boolean hasNext() {
                return this.i <= stop;
            }

            private void move() {
                int k;
                this.hasNext = true;
                for (k = 0; k < step && iterator.hasNext(); ++k) {
                    this.next = iterator.next();
                }
                this.hasNext = k == step;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T next() {
                try {
                    Object t = this.next;
                    return t;
                }
                finally {
                    this.move();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T extends Comparable<? super T>> Iterator<T> sorted(Iterator<T> iterator) {
        List<T> list = Iterators.list(iterator);
        Collections.sort(list);
        return list.iterator();
    }

    public static <T, K> Iterator<T> sorted(Iterator<T> iterator, final Comparator<? super K> cmp, final Mapper<T, K> key, final boolean reverse) {
        Mapper valueToKeyValue = new Mapper<T, Couple<K, T>>(){

            @Override
            public Couple<K, T> map(T arg) {
                return new Couple(key.map(arg), arg);
            }
        };
        Mapper keyValueToValue = new Mapper<Couple<K, T>, T>(){

            @Override
            public T map(Couple<K, T> arg) {
                return arg.f1;
            }
        };
        Comparator keyComparator = new Comparator<Couple<K, T>>(){

            @Override
            public int compare(Couple<K, T> o1, Couple<K, T> o2) {
                return (reverse ? -1 : 1) * cmp.compare(o1.f0, o2.f0);
            }
        };
        List list = Iterators.list(Iterators.map(valueToKeyValue, iterator));
        Collections.sort(list, keyComparator);
        return Iterators.map(keyValueToValue, list.iterator());
    }

    public static <T> Iterator<T> sorted(Iterator<T> iterator, Comparator<? super T> cmp) {
        List<T> list = Iterators.list(iterator);
        Collections.sort(list, cmp);
        return list.iterator();
    }

    public static <T, K extends Comparable<? super K>> Iterator<T> sorted(Iterator<T> iterator, Mapper<T, K> key, boolean reverse) {
        return Iterators.sorted(iterator, new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return o1.compareTo(o2);
            }
        }, key, reverse);
    }

    public static <T> List<T> tuple(Iterator<T> iterator) {
        return Collections.unmodifiableList(Iterators.list(iterator));
    }

    public static <T> Iterator<List<T>> zip(Iterator<Iterator<T>> iterators) {
        final List<Iterator<T>> iteratorList = Iterators.list(iterators);
        return new Iterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return Iterators.all(iteratorList.iterator(), new Predicate<Iterator<T>>(){

                    @Override
                    public Boolean map(Iterator<T> t) {
                        return t.hasNext();
                    }
                });
            }

            @Override
            public List<T> next() {
                return Iterators.tuple(Iterators.map(new Mapper<Iterator<T>, T>(){

                    @Override
                    public T map(Iterator<T> t) {
                        return t.next();
                    }
                }, iteratorList.iterator()));
            }

            @Override
            public void remove() {
                for (Iterator i : iteratorList) {
                    i.remove();
                }
            }
        };
    }

    public static <T1, T2> Iterator<Couple<T1, T2>> zip(final Iterator<T1> iterator1, final Iterator<T2> iterator2) {
        return new Iterator<Couple<T1, T2>>(){

            @Override
            public boolean hasNext() {
                return iterator1.hasNext() && iterator2.hasNext();
            }

            @Override
            public Couple<T1, T2> next() {
                return new Couple(iterator1.next(), iterator2.next());
            }

            @Override
            public void remove() {
                iterator1.remove();
                iterator2.remove();
            }
        };
    }

    public static <T> Iterator<T> reversed(Iterator<T> iterator) {
        List<T> list = Iterators.list(iterator);
        Collections.reverse(list);
        return list.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SingletonIterator<T>
    implements Iterator<T> {
        boolean returned = false;
        T t;

        public SingletonIterator(T t) {
            this.t = t;
        }

        @Override
        public boolean hasNext() {
            return !this.returned;
        }

        @Override
        public T next() {
            if (this.returned) {
                throw new NoSuchElementException();
            }
            this.returned = true;
            return this.t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EmptyIterator<T>
    implements Iterator<T> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

