/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.listener;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.engio.mbassy.dispatch.HandlerInvocation;
import net.engio.mbassy.listener.Enveloped;
import net.engio.mbassy.listener.Handler;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.listener.Invoke;
import net.engio.mbassy.listener.MessageListenerMetadata;
import net.engio.mbassy.listener.Synchronized;

public class MessageHandlerMetadata {
    private final Method handler;
    private final IMessageFilter[] filter;
    private final Handler handlerConfig;
    private final boolean isAsynchronous;
    private final Enveloped envelope;
    private final List<Class<?>> handledMessages = new LinkedList();
    private final boolean acceptsSubtypes;
    private final MessageListenerMetadata listenerConfig;
    private final boolean isSynchronized;
    private Class listeningClass;

    public MessageHandlerMetadata(Method handler, IMessageFilter[] filter, Handler handlerConfig, MessageListenerMetadata listenerConfig) {
        if (handler == null || handlerConfig == null) {
            throw new IllegalArgumentException("The message handler configuration may not be null");
        }
        this.handler = handler;
        this.filter = filter;
        this.handlerConfig = handlerConfig;
        this.isAsynchronous = handlerConfig.delivery().equals((Object)Invoke.Asynchronously);
        this.envelope = handler.getAnnotation(Enveloped.class);
        this.acceptsSubtypes = !handlerConfig.rejectSubtypes();
        this.listenerConfig = listenerConfig;
        boolean bl = this.isSynchronized = handler.getAnnotation(Synchronized.class) != null;
        if (this.envelope != null) {
            for (Class messageType : this.envelope.messages()) {
                this.handledMessages.add(messageType);
            }
        } else {
            this.handledMessages.add(handler.getParameterTypes()[0]);
        }
        this.handler.setAccessible(true);
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean useStrongReferences() {
        return this.listenerConfig.useStrongReferences();
    }

    public boolean isFromListener(Class listener) {
        return this.listenerConfig.isFromListener(listener);
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public boolean isFiltered() {
        return this.filter != null && this.filter.length > 0;
    }

    public int getPriority() {
        return this.handlerConfig.priority();
    }

    public Method getHandler() {
        return this.handler;
    }

    public IMessageFilter[] getFilter() {
        return this.filter;
    }

    public List<Class<?>> getHandledMessages() {
        return this.handledMessages;
    }

    public boolean isEnveloped() {
        return this.envelope != null;
    }

    public Class<? extends HandlerInvocation> getHandlerInvocation() {
        return this.handlerConfig.invocation();
    }

    public boolean handlesMessage(Class<?> messageType) {
        for (Class<?> handledMessage : this.handledMessages) {
            if (handledMessage.equals(messageType)) {
                return true;
            }
            if (!handledMessage.isAssignableFrom(messageType) || !this.acceptsSubtypes()) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsSubtypes() {
        return this.acceptsSubtypes;
    }

    public boolean isEnabled() {
        return this.handlerConfig.enabled();
    }
}

