/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import net.engio.mbassy.PublicationError;
import net.engio.mbassy.bus.AbstractSyncMessageBus;
import net.engio.mbassy.bus.ISyncMessageBus;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.bus.SyncBusConfiguration;

public class SyncMessageBus<T>
extends AbstractSyncMessageBus<T, SyncPostCommand> {
    public SyncMessageBus(SyncBusConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void publish(T message) {
        try {
            MessagePublication publication = this.createMessagePublication(message);
            publication.execute();
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError().setMessage("Error during publication of message").setCause(e).setPublishedObject(message));
        }
    }

    @Override
    public SyncPostCommand post(T message) {
        return new SyncPostCommand(message);
    }

    public class SyncPostCommand
    implements ISyncMessageBus.ISyncPostCommand {
        private T message;

        public SyncPostCommand(T message) {
            this.message = message;
        }

        @Override
        public void now() {
            SyncMessageBus.this.publish(this.message);
        }
    }
}

