/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.Collection;
import net.engio.mbassy.bus.ISyncMessageBus;
import net.engio.mbassy.common.DeadMessage;
import net.engio.mbassy.common.FilteredMessage;
import net.engio.mbassy.subscription.Subscription;

public class MessagePublication {
    private Collection<Subscription> subscriptions;
    private Object message;
    private State state = State.Scheduled;
    private boolean delivered = false;
    private ISyncMessageBus bus;

    protected MessagePublication(ISyncMessageBus bus, Collection<Subscription> subscriptions, Object message, State initialState) {
        this.bus = bus;
        this.subscriptions = subscriptions;
        this.message = message;
        this.state = initialState;
    }

    public boolean add(Subscription subscription) {
        return this.subscriptions.add(subscription);
    }

    protected void execute() {
        this.state = State.Running;
        for (Subscription sub : this.subscriptions) {
            sub.publish(this, this.message);
        }
        this.state = State.Finished;
        if (!this.delivered) {
            if (!this.isFilteredEvent() && !this.isDeadEvent()) {
                this.bus.post(new FilteredMessage(this.message)).now();
            } else if (!this.isDeadEvent()) {
                this.bus.post(new DeadMessage(this.message)).now();
            }
        }
    }

    public boolean isFinished() {
        return this.state.equals((Object)State.Finished);
    }

    public boolean isRunning() {
        return this.state.equals((Object)State.Running);
    }

    public boolean isScheduled() {
        return this.state.equals((Object)State.Scheduled);
    }

    public void markDelivered() {
        this.delivered = true;
    }

    public MessagePublication markScheduled() {
        if (!this.state.equals((Object)State.Initial)) {
            return this;
        }
        this.state = State.Scheduled;
        return this;
    }

    public MessagePublication setError() {
        this.state = State.Error;
        return this;
    }

    public boolean isDeadEvent() {
        return DeadMessage.class.isAssignableFrom(this.message.getClass());
    }

    public boolean isFilteredEvent() {
        return FilteredMessage.class.isAssignableFrom(this.message.getClass());
    }

    private static enum State {
        Initial,
        Scheduled,
        Running,
        Finished,
        Error;

    }

    public static class Factory {
        public MessagePublication createPublication(ISyncMessageBus owningBus, Collection<Subscription> subscriptions, Object message) {
            return new MessagePublication(owningBus, subscriptions, message, State.Initial);
        }
    }
}

