/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.bus.SyncBusConfiguration;

public class BusConfiguration
extends SyncBusConfiguration<BusConfiguration> {
    private static final ThreadFactory DaemonThreadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    };
    private int numberOfMessageDispatchers = 2;
    private ExecutorService executor;
    private int maximumNumberOfPendingMessages = Integer.MAX_VALUE;

    public static BusConfiguration Default() {
        return new BusConfiguration();
    }

    public BusConfiguration() {
        this.executor = new ThreadPoolExecutor(10, 10, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), DaemonThreadFactory);
    }

    public int getNumberOfMessageDispatchers() {
        return this.numberOfMessageDispatchers > 0 ? this.numberOfMessageDispatchers : 2;
    }

    public BusConfiguration setNumberOfMessageDispatchers(int numberOfMessageDispatchers) {
        this.numberOfMessageDispatchers = numberOfMessageDispatchers;
        return this;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public BusConfiguration setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public int getMaximumNumberOfPendingMessages() {
        return this.maximumNumberOfPendingMessages;
    }

    public BusConfiguration setMaximumNumberOfPendingMessages(int maximumNumberOfPendingMessages) {
        this.maximumNumberOfPendingMessages = maximumNumberOfPendingMessages > 0 ? maximumNumberOfPendingMessages : Integer.MAX_VALUE;
        return this;
    }
}

