/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.engio.mbassy.IPublicationErrorHandler;
import net.engio.mbassy.PublicationError;
import net.engio.mbassy.bus.ISyncMessageBus;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.bus.SyncBusConfiguration;
import net.engio.mbassy.common.DeadMessage;
import net.engio.mbassy.subscription.Subscription;
import net.engio.mbassy.subscription.SubscriptionManager;

public abstract class AbstractSyncMessageBus<T, P extends ISyncMessageBus.ISyncPostCommand>
implements ISyncMessageBus<T, P> {
    private final List<IPublicationErrorHandler> errorHandlers = new ArrayList<IPublicationErrorHandler>();
    private final MessagePublication.Factory publicationFactory;
    private final SubscriptionManager subscriptionManager;

    public AbstractSyncMessageBus(SyncBusConfiguration configuration) {
        this.subscriptionManager = new SubscriptionManager(configuration.getMetadataReader(), configuration.getSubscriptionFactory().setBus(this));
        this.publicationFactory = configuration.getMessagePublicationFactory();
    }

    protected MessagePublication.Factory getPublicationFactory() {
        return this.publicationFactory;
    }

    @Override
    public Collection<IPublicationErrorHandler> getRegisteredErrorHandlers() {
        return Collections.unmodifiableCollection(this.errorHandlers);
    }

    @Override
    public boolean unsubscribe(Object listener) {
        return this.subscriptionManager.unsubscribe(listener);
    }

    @Override
    public void subscribe(Object listener) {
        this.subscriptionManager.subscribe(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addErrorHandler(IPublicationErrorHandler handler) {
        AbstractSyncMessageBus abstractSyncMessageBus = this;
        synchronized (abstractSyncMessageBus) {
            this.errorHandlers.add(handler);
        }
    }

    protected MessagePublication createMessagePublication(T message) {
        Collection<Subscription> subscriptions = this.getSubscriptionsByMessageType(message.getClass());
        if ((subscriptions == null || subscriptions.isEmpty()) && !message.getClass().equals(DeadMessage.class)) {
            subscriptions = this.getSubscriptionsByMessageType(DeadMessage.class);
            return this.getPublicationFactory().createPublication(this, subscriptions, new DeadMessage(message));
        }
        return this.getPublicationFactory().createPublication(this, subscriptions, message);
    }

    protected Collection<Subscription> getSubscriptionsByMessageType(Class messageType) {
        return this.subscriptionManager.getSubscriptionsByMessageType(messageType);
    }

    public void handlePublicationError(PublicationError error) {
        for (IPublicationErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleError(error);
        }
    }
}

