/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.subscription;

import net.engio.mbassy.dispatch.AsynchronousHandlerInvocation;
import net.engio.mbassy.dispatch.EnvelopedMessageDispatcher;
import net.engio.mbassy.dispatch.FilteredMessageDispatcher;
import net.engio.mbassy.dispatch.IHandlerInvocation;
import net.engio.mbassy.dispatch.IMessageDispatcher;
import net.engio.mbassy.dispatch.MessageDispatcher;
import net.engio.mbassy.dispatch.MessagingContext;
import net.engio.mbassy.dispatch.ReflectiveHandlerInvocation;
import net.engio.mbassy.subscription.Subscription;

public class SubscriptionFactory {
    public Subscription createSubscription(MessagingContext context) {
        IHandlerInvocation invocation = this.buildInvocationForHandler(context);
        IMessageDispatcher dispatcher = this.buildDispatcher(context, invocation);
        return new Subscription(context, dispatcher);
    }

    protected IHandlerInvocation buildInvocationForHandler(MessagingContext context) {
        IHandlerInvocation invocation = new ReflectiveHandlerInvocation(context);
        if (context.getHandlerMetadata().isAsynchronous()) {
            invocation = new AsynchronousHandlerInvocation(invocation);
        }
        return invocation;
    }

    protected IMessageDispatcher buildDispatcher(MessagingContext context, IHandlerInvocation invocation) {
        IMessageDispatcher dispatcher = new MessageDispatcher(context, invocation);
        if (context.getHandlerMetadata().isEnveloped()) {
            dispatcher = new EnvelopedMessageDispatcher(dispatcher);
        }
        if (context.getHandlerMetadata().isFiltered()) {
            dispatcher = new FilteredMessageDispatcher(dispatcher);
        }
        return dispatcher;
    }
}

