/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.dispatch;

import net.engio.mbassy.common.ConcurrentSet;
import net.engio.mbassy.dispatch.IHandlerInvocation;
import net.engio.mbassy.dispatch.IMessageDispatcher;
import net.engio.mbassy.dispatch.MessagingContext;
import net.engio.mbassy.listener.IMessageFilter;

public class FilteredMessageDispatcher
implements IMessageDispatcher {
    private final IMessageFilter[] filter;
    private IMessageDispatcher del;

    public FilteredMessageDispatcher(IMessageDispatcher dispatcher) {
        this.del = dispatcher;
        this.filter = dispatcher.getContext().getHandlerMetadata().getFilter();
    }

    private boolean passesFilter(Object message) {
        if (this.filter == null) {
            return true;
        }
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i].accepts(message, this.getContext().getHandlerMetadata())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispatch(Object message, ConcurrentSet listeners) {
        if (this.passesFilter(message)) {
            this.del.dispatch(message, listeners);
        }
    }

    @Override
    public MessagingContext getContext() {
        return this.del.getContext();
    }

    @Override
    public IHandlerInvocation getInvocation() {
        return this.del.getInvocation();
    }
}

