/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.common;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.WeakHashMap;

public class ConcurrentSet<T>
implements Iterable<T> {
    private WeakHashMap<T, Entry<T>> entries = new WeakHashMap();
    private Entry<T> head;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentSet<T> add(T element) {
        if (element == null || this.entries.containsKey(element)) {
            return this;
        }
        ConcurrentSet concurrentSet = this;
        synchronized (concurrentSet) {
            this.insert(element);
        }
        return this;
    }

    public boolean contains(T element) {
        Entry<T> entry = this.entries.get(element);
        return entry != null && entry.getValue() != null;
    }

    private void insert(T element) {
        if (this.entries.containsKey(element)) {
            return;
        }
        this.head = this.head == null ? new Entry((Object)element) : new Entry(element, this.head);
        this.entries.put(element, this.head);
    }

    public int size() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentSet<T> addAll(Iterable<T> elements) {
        ConcurrentSet concurrentSet = this;
        synchronized (concurrentSet) {
            for (T element : elements) {
                if (element == null || this.entries.containsKey(element)) {
                    return this;
                }
                this.insert(element);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T element) {
        if (!this.entries.containsKey(element)) {
            return false;
        }
        ConcurrentSet concurrentSet = this;
        synchronized (concurrentSet) {
            Entry<T> listelement = this.entries.get(element);
            if (listelement == null) {
                return false;
            }
            if (listelement != this.head) {
                listelement.remove();
            } else {
                Entry<T> oldHead = this.head;
                this.head = this.head.next();
                ((Entry)oldHead).next = null;
            }
            this.entries.remove(element);
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Entry<T> current;
            {
                this.current = ConcurrentSet.this.head;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return false;
                }
                Object value = this.current.getValue();
                if (value == null) {
                    this.remove();
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public T next() {
                if (this.current == null) {
                    return null;
                }
                Object value = this.current.getValue();
                if (value == null) {
                    this.remove();
                    return this.next();
                }
                this.current = this.current.next();
                return value;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    return;
                }
                Entry newCurrent = this.current.next();
                ConcurrentSet.this.remove(this.current.getValue());
                this.current = newCurrent;
            }
        };
    }

    public class Entry<T> {
        private WeakReference<T> value;
        private Entry<T> next;
        private Entry<T> predecessor;

        private Entry(T value) {
            this.value = new WeakReference<T>(value);
        }

        private Entry(T value, Entry<T> next) {
            this(value);
            this.next = next;
            next.predecessor = this;
        }

        public T getValue() {
            return this.value.get();
        }

        public void remove() {
            if (this.predecessor != null) {
                this.predecessor.next = this.next;
                if (this.next != null) {
                    this.next.predecessor = this.predecessor;
                }
            } else if (this.next != null) {
                this.next.predecessor = null;
            }
            this.next = null;
            this.predecessor = null;
        }

        public Entry<T> next() {
            return this.next;
        }
    }
}

