/*
 * Decompiled with CFR 0.152.
 */
package net.emrekoc.speech.library;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import java.util.ArrayList;
import net.emrekoc.speech.library.enums.ErrorType;
import net.emrekoc.speech.library.listeners.SpeechListener;

public class SimpleRecognizer
implements RecognitionListener {
    String TAG = SimpleRecognizer.class.getSimpleName();
    private SpeechRecognizer recognizer;
    private SpeechListener listener;

    private SimpleRecognizer() {
    }

    public SimpleRecognizer(Context context) {
        this.recognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
        this.recognizer.setRecognitionListener((RecognitionListener)this);
    }

    public void setOnVoiceRecognizedListener(SpeechListener listener) {
        this.listener = listener;
    }

    public void startRecognizing(SpeechListener listener) {
        this.setOnVoiceRecognizedListener(listener);
        this.startRecognizing();
    }

    public void destroy() {
        this.recognizer.destroy();
        Log.d((String)this.TAG, (String)"destroy");
    }

    public void startRecognizing(Intent recognizingIntent) {
        if (!this.isSpeechListenerExists()) {
            return;
        }
        this.recognizer.startListening(recognizingIntent);
    }

    public void startRecognizing() {
        if (!this.isSpeechListenerExists()) {
            return;
        }
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "tr-TR");
        intent.putExtra("calling_package", this.getClass().getPackage().getName());
        this.recognizer.startListening(intent);
        Log.d((String)this.TAG, (String)"startRecognizing");
    }

    private boolean isSpeechListenerExists() {
        if (this.listener == null) {
            Log.e((String)this.TAG, (String)"You must call setOnVoiceRecognizedListener method before calling startRecognizing() method");
            return false;
        }
        return true;
    }

    public void onReadyForSpeech(Bundle params) {
        Log.i((String)this.TAG, (String)"onReadyForSpeech");
    }

    public void onBeginningOfSpeech() {
        Log.i((String)this.TAG, (String)"onBeginningOfSpeech");
    }

    public void onRmsChanged(float rmsdB) {
    }

    public void onBufferReceived(byte[] buffer) {
        Log.i((String)this.TAG, (String)"onBufferReceived");
    }

    public void onEndOfSpeech() {
        Log.i((String)this.TAG, (String)"onEndOfSpeech");
    }

    public void onError(int error) {
        this.recognizer.cancel();
        if (this.listener != null) {
            ErrorType errorType = null;
            switch (error) {
                case 1: {
                    errorType = ErrorType.NETWORK_TIMEOUT_ERROR;
                    break;
                }
                case 2: {
                    errorType = ErrorType.NO_CONNECTION_ERROR;
                    break;
                }
                case 3: {
                    errorType = ErrorType.AUDIO_RECORDING_ERROR;
                    break;
                }
                case 4: {
                    errorType = ErrorType.SERVER_ERROR;
                    break;
                }
                case 5: {
                    errorType = ErrorType.CLIENT_ERROR;
                    break;
                }
                case 6: {
                    errorType = ErrorType.SPEECH_TIMEOUT_ERROR;
                    break;
                }
                case 7: {
                    errorType = ErrorType.NO_MATCH_ERROR;
                    break;
                }
                case 8: {
                    errorType = ErrorType.RECOGNIZER_BUSY_ERROR;
                    break;
                }
                case 9: {
                    errorType = ErrorType.INSUFFICIENT_PERMISSIONS_ERROR;
                    break;
                }
                default: {
                    errorType = ErrorType.UNKNOWN;
                }
            }
            Log.i((String)this.TAG, (String)("onError: " + error));
            this.listener.onError(errorType);
        }
    }

    public void onResults(Bundle results) {
        Log.i((String)this.TAG, (String)"onResults");
        ArrayList arrayList = results.getStringArrayList("results_recognition");
        if (this.listener != null) {
            this.listener.onSpeechRecognized(arrayList);
        }
    }

    public void onPartialResults(Bundle partialResults) {
        Log.i((String)this.TAG, (String)"onPartialResults");
    }

    public void onEvent(int eventType, Bundle params) {
        Log.i((String)this.TAG, (String)"onEvent");
    }
}

