/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.PermissionOverrideAction;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.PermissionOverrideImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.RequestBody;

public class PermissionOverrideActionImpl
extends AuditableRestActionImpl<PermissionOverride>
implements PermissionOverrideAction {
    private boolean isOverride = true;
    private boolean allowSet = false;
    private boolean denySet = false;
    private long allow = 0L;
    private long deny = 0L;
    private final GuildChannel channel;
    private final IPermissionHolder permissionHolder;

    public PermissionOverrideActionImpl(PermissionOverride override) {
        this(override.getJDA(), override.getChannel(), override.isRoleOverride() ? override.getRole() : override.getMember());
    }

    public PermissionOverrideActionImpl(JDA api, GuildChannel channel, IPermissionHolder permissionHolder) {
        super(api, Route.Channels.CREATE_PERM_OVERRIDE.compile(channel.getId(), permissionHolder.getId()));
        this.channel = channel;
        this.permissionHolder = permissionHolder;
    }

    public PermissionOverrideActionImpl setOverride(boolean override) {
        this.isOverride = override;
        return this;
    }

    @Override
    protected BooleanSupplier finalizeChecks() {
        return () -> {
            if (!this.getGuild().getSelfMember().hasPermission(this.channel, Permission.MANAGE_PERMISSIONS)) {
                throw new InsufficientPermissionException(this.channel, Permission.MANAGE_PERMISSIONS);
            }
            return true;
        };
    }

    @Override
    @Nonnull
    public PermissionOverrideActionImpl setCheck(BooleanSupplier checks) {
        return (PermissionOverrideActionImpl)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public PermissionOverrideAction resetAllow() {
        this.allow = this.getCurrentAllow();
        this.allowSet = false;
        return this;
    }

    @Override
    @Nonnull
    public PermissionOverrideAction resetDeny() {
        this.deny = this.getCurrentDeny();
        this.denySet = false;
        return this;
    }

    @Override
    @Nonnull
    public GuildChannel getChannel() {
        return this.channel;
    }

    @Override
    public Role getRole() {
        return this.isRole() ? (Role)this.permissionHolder : null;
    }

    @Override
    public Member getMember() {
        return this.isMember() ? (Member)this.permissionHolder : null;
    }

    @Override
    public long getAllow() {
        return this.allow;
    }

    @Override
    public long getDeny() {
        return this.deny;
    }

    @Override
    public long getInherited() {
        return (this.allow ^ 0xFFFFFFFFFFFFFFFFL) & (this.deny ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean isMember() {
        return this.permissionHolder instanceof Member;
    }

    @Override
    public boolean isRole() {
        return this.permissionHolder instanceof Role;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermissionOverrideActionImpl setAllow(long allowBits) {
        Checks.notNegative(allowBits, "Granted permissions value");
        Checks.check(allowBits <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        this.allow = allowBits;
        this.deny &= allowBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.denySet = true;
        this.allowSet = true;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermissionOverrideActionImpl setDeny(long denyBits) {
        Checks.notNegative(denyBits, "Denied permissions value");
        Checks.check(denyBits <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
        this.deny = denyBits;
        this.allow &= denyBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.denySet = true;
        this.allowSet = true;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermissionOverrideActionImpl setPermissions(long allowBits, long denyBits) {
        return this.setAllow(allowBits).setDeny(denyBits);
    }

    private long getCurrentAllow() {
        if (this.isOverride) {
            return 0L;
        }
        PermissionOverride override = this.channel.getPermissionOverride(this.permissionHolder);
        return override == null ? 0L : override.getAllowedRaw();
    }

    private long getCurrentDeny() {
        if (this.isOverride) {
            return 0L;
        }
        PermissionOverride override = this.channel.getPermissionOverride(this.permissionHolder);
        return override == null ? 0L : override.getDeniedRaw();
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject object = DataObject.empty();
        object.put("type", this.isRole() ? "role" : "member");
        object.put("allow", this.allowSet ? this.allow : this.getCurrentAllow());
        object.put("deny", this.denySet ? this.deny : this.getCurrentDeny());
        this.reset();
        return this.getRequestBody(object);
    }

    @Override
    protected void handleSuccess(Response response, Request<PermissionOverride> request) {
        long id = this.permissionHolder.getIdLong();
        DataObject object = (DataObject)request.getRawBody();
        PermissionOverrideImpl override = new PermissionOverrideImpl(this.channel, id, this.permissionHolder);
        override.setAllow(object.getLong("allow"));
        override.setDeny(object.getLong("deny"));
        ((AbstractChannelImpl)this.channel).getOverrideMap().put(id, (Object)override);
        request.onSuccess(override);
    }
}

