/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDAInfo;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.RateLimiter;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.ratelimit.BotRateLimiter;
import net.dv8tion.jda.internal.requests.ratelimit.ClientRateLimiter;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.dv8tion.jda.internal.utils.JDALogger;
import net.dv8tion.jda.internal.utils.config.AuthorizationConfig;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import org.jetbrains.annotations.Async;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class Requester {
    public static final Logger LOG = JDALogger.getLog(Requester.class);
    public static final String DISCORD_API_PREFIX = String.format("https://discordapp.com/api/v%d/", 6);
    public static final String USER_AGENT = "DiscordBot (https://github.com/DV8FromTheWorld/JDA, " + JDAInfo.VERSION + ")";
    public static final RequestBody EMPTY_BODY = RequestBody.create(null, (byte[])new byte[0]);
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType MEDIA_TYPE_OCTET = MediaType.parse((String)"application/octet-stream; charset=utf-8");
    protected final JDAImpl api;
    protected final AuthorizationConfig authConfig;
    private final RateLimiter rateLimiter;
    private final OkHttpClient httpClient;
    private boolean isContextReady = false;
    private ConcurrentMap<String, String> contextMap = null;
    private volatile boolean retryOnTimeout = false;

    public Requester(JDA api) {
        this(api, ((JDAImpl)api).getAuthorizationConfig());
    }

    public Requester(JDA api, AuthorizationConfig authConfig) {
        if (authConfig == null) {
            throw new NullPointerException("Provided config was null!");
        }
        this.authConfig = authConfig;
        this.api = (JDAImpl)api;
        this.rateLimiter = authConfig.getAccountType() == AccountType.BOT ? new BotRateLimiter(this) : new ClientRateLimiter(this);
        this.httpClient = this.api.getHttpClient();
    }

    public void setContextReady(boolean ready) {
        this.isContextReady = ready;
    }

    public void setContext() {
        if (!this.isContextReady) {
            return;
        }
        if (this.contextMap == null) {
            this.contextMap = this.api.getContextMap();
        }
        this.contextMap.forEach(MDC::put);
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public <T> void request(@Async.Schedule net.dv8tion.jda.api.requests.Request<T> apiRequest) {
        if (this.rateLimiter.isShutdown) {
            throw new IllegalStateException("The Requester has been shutdown! No new requests can be requested!");
        }
        if (apiRequest.shouldQueue()) {
            this.rateLimiter.queueRequest(apiRequest);
        } else {
            this.execute(apiRequest, true);
        }
    }

    public Long execute(net.dv8tion.jda.api.requests.Request<?> apiRequest) {
        return this.execute(apiRequest, false);
    }

    public Long execute(net.dv8tion.jda.api.requests.Request<?> apiRequest, boolean handleOnRateLimit) {
        return this.execute(apiRequest, false, handleOnRateLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long execute(@Async.Execute net.dv8tion.jda.api.requests.Request<?> apiRequest, boolean retried, boolean handleOnRatelimit) {
        Long l;
        Route.CompiledRoute route = apiRequest.getRoute();
        Long retryAfter = this.rateLimiter.getRateLimit(route);
        if (retryAfter != null) {
            if (handleOnRatelimit) {
                apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(retryAfter, Collections.emptySet()));
            }
            return retryAfter;
        }
        Request.Builder builder = new Request.Builder();
        String url = DISCORD_API_PREFIX + route.getCompiledRoute();
        builder.url(url);
        String method = apiRequest.getRoute().getMethod().toString();
        RequestBody body = apiRequest.getBody();
        if (body == null && HttpMethod.requiresRequestBody((String)method)) {
            body = EMPTY_BODY;
        }
        builder.method(method, body).header("user-agent", USER_AGENT).header("accept-encoding", "gzip");
        if (url.startsWith(DISCORD_API_PREFIX)) {
            builder.header("authorization", this.authConfig.getToken());
        }
        if (apiRequest.getHeaders() != null) {
            for (Map.Entry header : apiRequest.getHeaders().entrySet()) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        Request request = builder.build();
        LinkedHashSet<String> rays = new LinkedHashSet<String>();
        Response[] responses = new Response[4];
        Response lastResponse = null;
        try {
            int attempt = 0;
            do {
                Call call = this.httpClient.newCall(request);
                responses[attempt] = lastResponse = call.execute();
                String cfRay = lastResponse.header("CF-RAY");
                if (cfRay != null) {
                    rays.add(cfRay);
                }
                if (lastResponse.code() < 500) break;
                LOG.debug("Requesting {} -> {} returned status {}... retrying (attempt {})", new Object[]{apiRequest.getRoute().getMethod(), url, lastResponse.code(), ++attempt});
                try {
                    Thread.sleep(50 * attempt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (attempt < 3 && lastResponse.code() >= 500);
            if (lastResponse.code() >= 500) {
                net.dv8tion.jda.api.requests.Response response = new net.dv8tion.jda.api.requests.Response(lastResponse, -1L, rays);
                apiRequest.handleResponse(response);
                Response[] responseArray = null;
                return responseArray;
            }
            retryAfter = this.rateLimiter.handleResponse(route, lastResponse);
            if (!rays.isEmpty()) {
                LOG.debug("Received response with following cf-rays: {}", rays);
            }
            if (retryAfter == null) {
                apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(lastResponse, -1L, rays));
            } else if (handleOnRatelimit) {
                apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(lastResponse, retryAfter, rays));
            }
            l = retryAfter;
            return l;
        }
        catch (SocketException | SocketTimeoutException e) {
            if (this.retryOnTimeout && !retried) {
                l = this.execute(apiRequest, true, handleOnRatelimit);
                return l;
            }
            LOG.error("Requester timed out while executing a request", (Throwable)e);
            apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(lastResponse, e, rays));
            l = null;
            return l;
        }
        catch (Exception e) {
            LOG.error("There was an exception while executing a REST request", (Throwable)e);
            apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(lastResponse, e, rays));
            l = null;
            return l;
        }
        finally {
            for (Response r : responses) {
                if (r == null) break;
                r.close();
            }
        }
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRetryOnTimeout(boolean retryOnTimeout) {
        this.retryOnTimeout = retryOnTimeout;
    }

    public void shutdown() {
        this.rateLimiter.shutdown();
    }

    public static InputStream getBody(Response response) throws IOException {
        String encoding = response.header("content-encoding", "");
        BufferedInputStream data = new BufferedInputStream(response.body().byteStream());
        ((InputStream)data).mark(256);
        try {
            if (encoding.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(data);
            }
            if (encoding.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(data, new Inflater(true));
            }
        }
        catch (ZipException ex) {
            ((InputStream)data).reset();
            LOG.error("Failed to read gzip content for response. Headers: {}\nContent: '{}'", new Object[]{response.headers(), JDALogger.getLazyString(() -> new String(IOUtil.readFully(data))), ex});
            return null;
        }
        return data;
    }
}

