/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.managers.WebhookManager;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.managers.WebhookManagerImpl;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;

public class WebhookImpl
implements Webhook {
    protected volatile WebhookManager manager = null;
    private final ReentrantLock mngLock = new ReentrantLock();
    private final TextChannel channel;
    private final long id;
    private Member owner;
    private User user;
    private String token;

    public WebhookImpl(TextChannel channel, long id) {
        this.channel = channel;
        this.id = id;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.channel.getJDA();
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.channel.getGuild();
    }

    @Override
    @Nonnull
    public TextChannel getChannel() {
        return this.channel;
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public User getDefaultUser() {
        return this.user;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.user.getName();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    @Nonnull
    public String getUrl() {
        return Requester.DISCORD_API_PREFIX + "webhooks/" + this.getId() + (this.getToken() == null ? "" : "/" + this.getToken());
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        if (this.isFake()) {
            throw new IllegalStateException("Fake Webhooks (such as those retrieved from Audit Logs) cannot be used for deletion!");
        }
        Route.CompiledRoute route = Route.Webhooks.DELETE_TOKEN_WEBHOOK.compile(this.getId(), this.token);
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public WebhookManager getManager() {
        if (this.isFake()) {
            throw new IllegalStateException("Fake Webhooks (such as those retrieved from Audit Logs) cannot provide a WebhookManager!");
        }
        WebhookManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new WebhookManagerImpl(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public boolean isFake() {
        return this.token == null;
    }

    public WebhookImpl setOwner(Member member) {
        this.owner = member;
        return this;
    }

    public WebhookImpl setToken(String token) {
        this.token = token;
        return this;
    }

    public WebhookImpl setUser(User user) {
        this.user = user;
        return this;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WebhookImpl)) {
            return false;
        }
        WebhookImpl impl = (WebhookImpl)obj;
        return impl.id == this.id;
    }

    public String toString() {
        return "WH:" + this.getName() + "(" + this.id + ")";
    }
}

